/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.pjbdd.examples;

import java.math.BigInteger;
import org.sosy_lab.pjbdd.api.Builders;
import org.sosy_lab.pjbdd.api.Creator;
import org.sosy_lab.pjbdd.examples.NQueens;

public final class NQueensCBDD {
    private NQueensCBDD() {
    }

    public static void main(String[] args) {
        int n = 12;
        Creator creator = Builders.cbddBuilder().setTableType(Builders.TableType.CASArray).setVarCount(n * n).setTableSize(100000).setThreads(6).setCacheSize(10000).setParallelizationType(Builders.ParallelizationType.FORK_JOIN).build();
        NQueens queens = new NQueens(n, creator);
        long start = System.currentTimeMillis();
        queens.build();
        BigInteger count = queens.solve();
        long end = System.currentTimeMillis();
        System.out.println("CAS N=" + n + ":\n SatCount: " + count + "\n Duration: " + (end - start) + "ms");
        queens.queen = null;
        queens.board = null;
        queens.close();
        System.gc();
    }
}

