/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.pjbdd.examples;

import java.math.BigInteger;
import java.util.Arrays;
import org.sosy_lab.pjbdd.api.Builders;
import org.sosy_lab.pjbdd.api.DD;
import org.sosy_lab.pjbdd.api.ZDDCreator;
import org.sosy_lab.pjbdd.examples.Example;

public class NQueensZDD
implements Example {
    private final ZDDCreator creator;
    private final int n;
    private DD[] board;
    private DD queen;

    public NQueensZDD(int n, ZDDCreator creator) {
        this.creator = creator;
        this.n = n;
    }

    private DD get(int i, int j) {
        return this.board[i + j * this.n];
    }

    @Override
    public void build() {
        this.queen = this.creator.empty();
        this.board = new DD[this.n * this.n];
        DD one = this.creator.base();
        DD zero = this.creator.empty();
        boolean[] mark = new boolean[this.n * this.n];
        for (int i = 0; i < this.n * this.n; ++i) {
            this.board[i] = this.creator.makeNode(zero, one, i);
        }
        DD firstRow = zero;
        for (int i = 0; i < this.n; ++i) {
            firstRow = this.creator.union(firstRow, this.get(0, i));
        }
        DD lastRow = firstRow;
        for (int i = 1; i < this.n; ++i) {
            DD thisRow = zero;
            for (int j = 0; j < this.n; ++j) {
                DD build = this.build(i, j, lastRow, mark);
                thisRow = this.creator.union(thisRow, build);
            }
            lastRow = thisRow;
        }
        this.queen = lastRow;
    }

    private DD build(int i, int j, DD row, boolean[] mark) {
        int a;
        int b;
        int k;
        Arrays.fill(mark, false);
        for (k = 0; k < i; ++k) {
            mark[k + this.n * j] = true;
        }
        for (k = 1; k <= i; ++k) {
            b = i - k;
            a = j - k;
            if (this.valid(b, a)) {
                mark[b + this.n * a] = true;
            }
            if (!this.valid(b, a = j + k)) continue;
            mark[b + this.n * a] = true;
        }
        for (k = 0; k < this.n * this.n; ++k) {
            if (!mark[k]) continue;
            a = k / this.n;
            b = k % this.n;
            row = this.creator.subSet0(row, this.get(b, a));
        }
        return this.creator.product(row, this.get(i, j));
    }

    private boolean valid(int a, int b) {
        return a >= 0 && a < this.n && b >= 0 && b < this.n;
    }

    @Override
    public BigInteger solve() {
        return this.creator.satCount(this.queen);
    }

    @Override
    public DD solution() {
        return this.queen;
    }

    @Override
    public void close() {
        this.queen = null;
        this.board = null;
    }

    public static void main(String ... args) {
        if (args.length == 0) {
            args = new String[]{"8", "9", "10", "11", "12"};
        }
        for (String str : args) {
            int n = Integer.parseInt(str);
            NQueensZDD queens = new NQueensZDD(n, Builders.zddBuilder().setVarCount(n * n).setTableSize(100000).setSelectedCacheSize(10000).build());
            long start = System.currentTimeMillis();
            queens.build();
            BigInteger count = queens.solve();
            long end = System.currentTimeMillis();
            System.out.println("n=" + n + ":\n Sat Count: " + count.intValueExact() + "\n Duration: " + (end - start) + "ms");
            queens.queen = null;
            queens.board = null;
            queens.creator.shutdown();
            System.gc();
        }
    }
}

