/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.pjbdd.examples;

import java.math.BigInteger;
import java.util.Arrays;
import org.sosy_lab.pjbdd.api.Builders;
import org.sosy_lab.pjbdd.api.DD;
import org.sosy_lab.pjbdd.api.ZDDCreator;
import org.sosy_lab.pjbdd.examples.Example;

public class NQueensZDDWithUnateSetAlgebra
implements Example {
    private final ZDDCreator creator;
    private final int n;
    private DD[] board;
    private DD queen;

    public NQueensZDDWithUnateSetAlgebra(int n, ZDDCreator creator) {
        this.creator = creator;
        this.n = n;
    }

    private DD get(int i, int j) {
        return this.board[i + j * this.n];
    }

    @Override
    public void build() {
        int i;
        this.queen = this.creator.empty();
        this.board = new DD[this.n * this.n];
        DD one = this.creator.base();
        DD zero = this.creator.empty();
        boolean[] mark = new boolean[this.n * this.n];
        for (i = 0; i < this.n * this.n; ++i) {
            this.board[i] = this.creator.makeNode(zero, one, i);
        }
        for (i = 0; i < this.n; ++i) {
            this.queen = this.creator.union(this.queen, this.get(0, i));
        }
        for (i = 1; i < this.n; ++i) {
            DD tmp = zero;
            for (int j = 0; j < this.n; ++j) {
                DD build = this.build(i, j, mark);
                tmp = this.creator.union(tmp, build);
            }
            this.queen = tmp;
        }
    }

    private DD build(int i, int j, boolean[] mark) {
        int k;
        Arrays.fill(mark, false);
        for (k = 0; k < i; ++k) {
            mark[k + this.n * j] = true;
        }
        for (k = 1; k <= i; ++k) {
            int b = i - k;
            int a = j - k;
            if (this.valid(b, a)) {
                mark[b + this.n * a] = true;
            }
            if (!this.valid(b, a = j + k)) continue;
            mark[b + this.n * a] = true;
        }
        DD ret = this.creator.empty();
        for (int k2 = 0; k2 < this.n * this.n; ++k2) {
            int a = k2 / this.n;
            int b = k2 % this.n;
            if (!mark[k2]) continue;
            ret = this.creator.union(ret, this.get(b, a));
        }
        ret = this.creator.exclude(this.queen, ret);
        ret = this.creator.product(ret, this.get(i, j));
        return ret;
    }

    private boolean valid(int a, int b) {
        return a >= 0 && a < this.n && b >= 0 && b < this.n;
    }

    @Override
    public BigInteger solve() {
        return this.creator.satCount(this.queen);
    }

    @Override
    public DD solution() {
        return this.queen;
    }

    public static void main(String[] args) {
        if (args.length == 0) {
            args = new String[]{"8", "9", "10", "11", "12"};
        }
        for (String str : args) {
            int n = Integer.parseInt(str);
            NQueensZDDWithUnateSetAlgebra queens = new NQueensZDDWithUnateSetAlgebra(n, Builders.zddBuilder().setVarCount(n * n).setTableSize(100000).setSelectedCacheSize(10000).build());
            long start = System.currentTimeMillis();
            queens.build();
            BigInteger count = queens.solve();
            long end = System.currentTimeMillis();
            System.out.println("n=" + n + ":\n Sat Count: " + count.intValueExact() + "\n Duration: " + (end - start) + "ms");
            queens.queen = null;
            queens.board = null;
            queens.close();
            System.gc();
        }
    }

    @Override
    public void close() {
        this.queen = null;
        this.board = null;
        this.creator.shutdown();
    }
}

