/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.pjbdd.examples;

import org.sosy_lab.pjbdd.api.Builders;
import org.sosy_lab.pjbdd.api.Creator;
import org.sosy_lab.pjbdd.api.DD;
import org.sosy_lab.pjbdd.api.ZDDCreator;
import org.sosy_lab.pjbdd.util.parser.DotExporter;

public class SimpleFunctionExample {
    private SimpleFunctionExample() {
    }

    public static void main(String[] args) {
        String logMsg = "Construct Boolean formula f = x | (y & -z)\nAs BDD .dot: \n" + new DotExporter().bddToString(SimpleFunctionExample.buildBDDEncoding()) + "\nAs ZDD .dot: \n" + new DotExporter().bddToString(SimpleFunctionExample.buildZDDEncoding());
        System.out.println(logMsg);
    }

    private static DD buildBDDEncoding() {
        Creator c = Builders.bddBuilder().setVarCount(3).build();
        DD x = c.makeIthVar(0);
        DD y = c.makeIthVar(1);
        DD z = c.makeIthVar(2);
        return c.makeOr(x, c.makeAnd(y, c.makeNot(z)));
    }

    private static DD buildZDDEncoding() {
        ZDDCreator c = Builders.zddBuilder().setVarCount(3).build();
        DD dontcarz0 = c.makeNode(c.empty(), c.empty(), 2);
        DD dontcarz1 = c.makeNode(c.base(), c.base(), 2);
        DD dontcary0 = c.makeNode(dontcarz0, dontcarz0, 1);
        DD dontcary1 = c.makeNode(dontcarz1, dontcarz1, 1);
        DD bddx = c.makeNode(dontcary0, dontcary1, 0);
        DD y = c.makeNode(dontcarz0, dontcarz1, 1);
        DD bddy = c.makeNode(y, y, 0);
        DD z = c.makeNode(c.empty(), c.base(), 2);
        DD yz = c.makeNode(z, z, 1);
        DD bddz = c.makeNode(yz, yz, 0);
        return c.union(bddx, c.difference(bddy, bddz));
    }
}

