/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.pjbdd.intBDD;

import java.lang.invoke.MethodHandles;
import java.lang.invoke.VarHandle;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import org.sosy_lab.pjbdd.intBDD.IntUniqueTable;
import org.sosy_lab.pjbdd.intBDD.IntUniqueTableImpl;

public class CasIntUniqueTable
extends IntUniqueTableImpl
implements IntUniqueTable {
    private static final VarHandle arrayHandle = MethodHandles.arrayElementVarHandle(int[].class);
    private static final VarHandle FREE_COUNTER_HANDLE;
    private static final VarHandle NEXT_FREE_HANDLE;
    private final AtomicInteger readAccesses = new AtomicInteger();
    private final Lock resizeMonitor = new ReentrantLock();
    private final Object readMonitor = new Object();
    private boolean resizeInProgress = false;

    public CasIntUniqueTable(int initialSize, int increaseFactor, boolean disableGC) {
        super(initialSize, increaseFactor, disableGC);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int getOrCreate(int var, int low, int high) {
        int res;
        boolean resize = false;
        boolean computationComplete = false;
        this.tryResizing();
        try {
            this.readAccesses.incrementAndGet();
            int hash = this.hashNode(var, low, high);
            int head = res = this.getNodeWithHash(hash);
            while (res != 0) {
                if (this.getVariable(res) == var && this.getLow(res) == low && this.getHigh(res) == high) {
                    computationComplete = true;
                    break;
                }
                res = this.getNext(res);
            }
            if (!computationComplete) {
                res = this.getNextFree();
                if (res < 2) {
                    resize = true;
                } else {
                    computationComplete = this.createNode(res, low, high, var, hash, head);
                }
            }
        }
        finally {
            this.readAccesses.decrementAndGet();
        }
        if (resize) {
            this.tryResizing();
        }
        if (!computationComplete) {
            return this.getOrCreate(var, low, high);
        }
        return res;
    }

    @Override
    protected boolean createNode(int node, int low, int high, int var, int hash, int head) {
        if (!this.setHashAtomic(hash, node, head)) {
            return false;
        }
        this.setNext(node, head);
        this.setVariable(node, var);
        this.setLow(node, low);
        this.setHigh(node, high);
        this.atomicDecrementFreeCounter();
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void tryResizing() {
        block16: {
            if (this.checkResize()) {
                Object object = this.readMonitor;
                synchronized (object) {
                    this.readMonitor.notify();
                }
                this.resizeMonitor.lock();
                try {
                    if (!this.checkResize()) break block16;
                    this.resizeInProgress = true;
                    while (this.readAccesses.get() > 0) {
                        try {
                            object = this.readMonitor;
                            synchronized (object) {
                                this.readMonitor.wait(1000L);
                            }
                        }
                        catch (InterruptedException interruptedException) {
                        }
                    }
                    try {
                        this.resizeTable();
                    }
                    finally {
                        this.resizeInProgress = false;
                    }
                }
                finally {
                    this.resizeMonitor.unlock();
                }
            }
        }
    }

    @Override
    public void setMaxRef(int node) {
        if (!this.disableGC) {
            arrayHandle.set(this.table, node * this.nodeSize + 5, -1);
        }
    }

    @Override
    public void incRef(int ... roots) {
        if (this.disableGC) {
            return;
        }
        for (int r : roots) {
            if (this.table[r * this.nodeSize + 5] == -1) continue;
            arrayHandle.getAndAdd(this.table, r * this.nodeSize + 5, 1);
        }
    }

    @Override
    public int getNodeCount() {
        return this.nodeCount - this.atomicReadFreeCounter();
    }

    @Override
    public void decRef(int ... roots) {
        if (this.disableGC) {
            return;
        }
        for (int r : roots) {
            int old = this.table[r * this.nodeSize + 5];
            if (old == -1 || old <= 0) continue;
            arrayHandle.getAndAdd(this.table, r * this.nodeSize + 5, -1);
        }
    }

    @Override
    protected boolean hasRef(int r) {
        return !arrayHandle.get(this.table, r * this.nodeSize + 5).equals(0);
    }

    protected boolean setHashAtomic(int hash, int index, int old) {
        if (old == -1) {
            this.table[hash * this.nodeSize + 3] = index;
            return true;
        }
        return arrayHandle.weakCompareAndSetPlain(this.table, hash * this.nodeSize + 3, old, index);
    }

    private void atomicDecrementFreeCounter() {
        FREE_COUNTER_HANDLE.getAndAdd(this, -1);
    }

    private int atomicReadFreeCounter() {
        return FREE_COUNTER_HANDLE.get(this);
    }

    private boolean atomicSetNextFree(int value, int old) {
        return NEXT_FREE_HANDLE.weakCompareAndSetPlain(this, old, value);
    }

    @Override
    protected int getNextFree() {
        int next = NEXT_FREE_HANDLE.get(this);
        if (this.atomicSetNextFree(this.getNext(next), next)) {
            return next;
        }
        return this.getNextFree();
    }

    @Override
    protected boolean checkResize() {
        if (this.nextFree > 1) {
            return this.resizeInProgress;
        }
        return true;
    }

    static {
        try {
            FREE_COUNTER_HANDLE = MethodHandles.lookup().findVarHandle(IntUniqueTableImpl.class, "freeCounter", Integer.TYPE);
            NEXT_FREE_HANDLE = MethodHandles.lookup().findVarHandle(IntUniqueTableImpl.class, "nextFree", Integer.TYPE);
        }
        catch (ReflectiveOperationException e) {
            throw new AssertionError((Object)e);
        }
    }
}

