/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.pjbdd.intBDD;

import java.util.concurrent.ForkJoinPool;
import java.util.concurrent.ForkJoinTask;
import java.util.concurrent.Future;
import org.sosy_lab.pjbdd.intBDD.IntAlgorithm;
import org.sosy_lab.pjbdd.intBDD.IntBDDAlgorithm;
import org.sosy_lab.pjbdd.intBDD.IntNodeManager;
import org.sosy_lab.pjbdd.intBDD.cache.IntNotCache;
import org.sosy_lab.pjbdd.intBDD.cache.IntOpCache;
import org.sosy_lab.pjbdd.intBDD.cache.IntQuantCache;
import org.sosy_lab.pjbdd.util.threadpool.ParallelismManager;

public class ForkJoinIntAlgorithm
extends IntBDDAlgorithm {
    private final ParallelismManager parallelismManager;

    public ForkJoinIntAlgorithm(IntOpCache opCache, IntOpCache iteCache, IntNotCache notCache, IntQuantCache quantCache, IntOpCache composeCache, IntNodeManager nodeManager, ParallelismManager parallelismManager) {
        super(opCache, iteCache, notCache, quantCache, composeCache, nodeManager);
        this.parallelismManager = parallelismManager;
    }

    @Override
    public int makeIte(int f, int g, int h) {
        int top = this.topVarForLevels(this.level(f), this.level(g), this.level(h));
        int res = this.iteCheck(f, g, h);
        if (res != -1) {
            return res;
        }
        if (this.parallelismManager.canFork(top)) {
            this.parallelismManager.taskSupplied();
            ForkJoinPool service = this.parallelismManager.getThreadPool();
            Future lowTask = service.submit(() -> this.makeIte(this.restrictIf(f, top, this.makeFalse()), this.restrictIf(g, top, this.makeFalse()), this.restrictIf(h, top, this.makeFalse())));
            Future highTask = service.submit(() -> this.makeIte(this.restrictIf(f, top, this.makeTrue()), this.restrictIf(g, top, this.makeTrue()), this.restrictIf(h, top, this.makeTrue())));
            int high = (Integer)((ForkJoinTask)highTask).join();
            int low = (Integer)((ForkJoinTask)lowTask).join();
            this.parallelismManager.taskDone();
            res = this.makeNode(top, low, high);
        } else {
            int low = this.makeIte(this.restrictIf(f, top, this.makeFalse()), this.restrictIf(g, top, this.makeFalse()), this.restrictIf(h, top, this.makeFalse()));
            int high = this.makeIte(this.restrictIf(f, top, this.makeTrue()), this.restrictIf(g, top, this.makeTrue()), this.restrictIf(h, top, this.makeTrue()));
            res = this.makeNode(low, high, top);
        }
        this.cacheIte(f, g, h, res);
        return res;
    }

    @Override
    public int makeOp(int f1, int f2, IntAlgorithm.ApplyOp op) {
        int res = this.applyCheck(f1, f2, op);
        if (res != -1) {
            return res;
        }
        int topVar = this.topVarForLevels(this.level(f1), this.level(f2));
        int lowF1 = this.level(f1) <= this.level(f2) ? this.low(f1) : f1;
        int lowF2 = this.level(f2) <= this.level(f1) ? this.low(f2) : f2;
        int highF1 = this.level(f1) <= this.level(f2) ? this.high(f1) : f1;
        int highF2 = this.level(f2) <= this.level(f1) ? this.high(f2) : f2;
        int low = this.applyCheck(lowF1, lowF2, op);
        int high = this.applyCheck(highF1, highF2, op);
        if (this.parallelismManager.canFork(topVar) && low == -1 && high == -1) {
            res = this.asyncExpand(lowF1, lowF2, highF1, highF2, op, topVar);
        } else {
            if (low == -1) {
                low = this.makeOp(lowF1, lowF2, op);
            }
            if (high == -1) {
                high = this.makeOp(highF1, highF2, op);
            }
            res = this.makeNode(low, high, topVar);
        }
        this.cacheApply(f1, f2, op, res);
        return res;
    }

    private int asyncExpand(int lF1, int lF2, int hF1, int hF2, IntAlgorithm.ApplyOp op, int top) {
        this.parallelismManager.taskSupplied();
        this.parallelismManager.taskSupplied();
        ForkJoinPool service = this.parallelismManager.getThreadPool();
        Future lowTask = service.submit(() -> this.makeOp(lF1, lF2, op));
        Future highTask = service.submit(() -> this.makeOp(hF1, hF2, op));
        int high = (Integer)((ForkJoinTask)highTask).join();
        int low = (Integer)((ForkJoinTask)lowTask).join();
        this.parallelismManager.taskDone();
        this.parallelismManager.taskDone();
        return this.makeNode(low, high, top);
    }

    @Override
    public void shutDown() {
        super.shutDown();
        this.parallelismManager.shutdown();
    }
}

