/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.pjbdd.intBDD;

import com.google.common.primitives.Ints;
import org.sosy_lab.pjbdd.intBDD.IntAlgorithm;
import org.sosy_lab.pjbdd.intBDD.IntNodeManager;
import org.sosy_lab.pjbdd.intBDD.cache.IntNotCache;
import org.sosy_lab.pjbdd.intBDD.cache.IntOpCache;
import org.sosy_lab.pjbdd.intBDD.cache.IntQuantCache;
import org.sosy_lab.pjbdd.intBDD.cache.NotCacheData;
import org.sosy_lab.pjbdd.intBDD.cache.OpCacheData;
import org.sosy_lab.pjbdd.intBDD.cache.QuantCacheData;
import org.sosy_lab.pjbdd.util.HashCodeGenerator;
import org.sosy_lab.pjbdd.util.IntArrayUtils;

public class IntBDDAlgorithm
implements IntAlgorithm {
    protected final IntOpCache opCache;
    protected final IntOpCache iteCache;
    protected final IntQuantCache quantCache;
    protected final IntNotCache notCache;
    protected final IntOpCache composeCache;
    protected final IntNodeManager nodeManager;
    private static final int[][] baseOprResults = new int[][]{{0, 0, 0, 1}, {0, 1, 1, 0}, {0, 1, 1, 1}, {1, 1, 1, 0}, {1, 0, 0, 0}, {1, 1, 0, 1}, {1, 0, 0, 1}, {0, 0, 1, 0}, {0, 1, 0, 0}, {1, 0, 1, 1}, {1, 1, 0, 0}};

    public IntBDDAlgorithm(IntOpCache opCache, IntOpCache iteCache, IntNotCache notCache, IntQuantCache quantCache, IntOpCache composeCache, IntNodeManager nodeManager) {
        this.notCache = notCache;
        this.iteCache = iteCache;
        this.opCache = opCache;
        this.quantCache = quantCache;
        this.composeCache = composeCache;
        this.nodeManager = nodeManager;
    }

    @Override
    public int makeNot(int bdd) {
        if (this.isZero(bdd)) {
            return this.makeTrue();
        }
        if (this.isOne(bdd)) {
            return this.makeFalse();
        }
        int res = this.notCacheLookup(bdd);
        if (res != -1) {
            return res;
        }
        int low = this.makeNot(this.low(bdd));
        int high = this.makeNot(this.high(bdd));
        res = this.makeNode(low, high, this.var(bdd));
        this.cacheNot(bdd, res);
        return res;
    }

    @Override
    public void shutDown() {
        this.opCache.clear();
        this.notCache.clear();
    }

    @Override
    public int makeFalse() {
        return this.nodeManager.getFalse();
    }

    @Override
    public int makeTrue() {
        return this.nodeManager.getTrue();
    }

    @Override
    public int makeNode(int low, int high, int var) {
        return this.nodeManager.makeNode(var, low, high);
    }

    protected int iteCheck(int f, int g, int h) {
        if (this.isOne(f) || g == h) {
            return g;
        }
        if (this.isZero(f)) {
            return h;
        }
        if (this.isOne(g) && this.isZero(h)) {
            return f;
        }
        if (this.isZero(g) && this.isOne(h)) {
            return this.makeNot(f);
        }
        if (this.isOne(g)) {
            return this.makeOp(f, h, IntAlgorithm.ApplyOp.OP_OR);
        }
        if (this.isZero(g)) {
            return this.makeOp(f, this.makeNot(h), IntAlgorithm.ApplyOp.OP_NOR);
        }
        if (this.isOne(h)) {
            return this.makeOp(f, h, IntAlgorithm.ApplyOp.OP_AND);
        }
        if (this.isZero(h)) {
            return this.makeOp(f, this.makeNot(h), IntAlgorithm.ApplyOp.OP_NAND);
        }
        return this.iteCacheLookup(f, g, h);
    }

    @Override
    public int makeIte(int f, int g, int h) {
        int res = this.iteCheck(f, g, h);
        if (res != -1) {
            return res;
        }
        int topVar = this.topVarForLevels(this.level(f), this.level(g), this.level(h));
        int low = this.makeIte(this.restrictIf(f, topVar, this.makeFalse()), this.restrictIf(g, topVar, this.makeFalse()), this.restrictIf(h, topVar, this.makeFalse()));
        int high = this.makeIte(this.restrictIf(f, topVar, this.makeTrue()), this.restrictIf(g, topVar, this.makeTrue()), this.restrictIf(h, topVar, this.makeTrue()));
        res = this.makeNode(low, high, topVar);
        this.cacheIte(f, g, h, res);
        return res;
    }

    @Override
    public int makeOp(int f1, int f2, IntAlgorithm.ApplyOp op) {
        int res = this.applyCheck(f1, f2, op);
        if (res != -1) {
            return res;
        }
        int topVar = this.topVarForLevels(this.level(f1), this.level(f2));
        int low = this.makeOp(this.restrictIf(f1, topVar, this.makeFalse()), this.restrictIf(f2, topVar, this.makeFalse()), op);
        int high = this.makeOp(this.restrictIf(f1, topVar, this.makeTrue()), this.restrictIf(f2, topVar, this.makeTrue()), op);
        res = this.makeNode(low, high, topVar);
        this.cacheApply(f1, f2, op, res);
        return res;
    }

    @Override
    public int makeExquant(int f, int[] levels) {
        if (this.isConst(f) || this.level(f) > levels[0] && levels.length == 1) {
            return f;
        }
        int res = this.quantCheck(f, levels);
        if (res != -1) {
            return res;
        }
        int fLow = this.nodeManager.low(f);
        int fHigh = this.nodeManager.high(f);
        int fLevel = this.level(f);
        if (fLevel > levels[0]) {
            int[] newTail = IntArrayUtils.subArray(levels, 1, levels.length);
            res = this.makeExquant(f, newTail);
        } else if (fLevel == levels[0]) {
            if (levels.length == 1) {
                res = this.makeOp(fHigh, fLow, IntAlgorithm.ApplyOp.OP_OR);
            } else {
                int[] newTail = IntArrayUtils.subArray(levels, 1, levels.length);
                res = this.makeOp(this.makeExquant(fLow, newTail), this.makeExquant(fHigh, newTail), IntAlgorithm.ApplyOp.OP_OR);
            }
        } else {
            res = this.expandExquant(fLow, fHigh, levels, this.var(f));
        }
        this.cacheQuant(f, levels, res);
        return res;
    }

    protected int expandExquant(int fLow, int fHigh, int[] levels, int var) {
        int high = this.makeExquant(fHigh, levels);
        int low = this.makeExquant(fLow, levels);
        return this.makeNode(low, high, var);
    }

    @Override
    public int makeExquant(int f, int level) {
        if (this.isConst(f) || this.level(f) > level) {
            return f;
        }
        int res = this.quantCheck(f, new int[]{level});
        if (res != -1) {
            return res;
        }
        if (this.level(f) == level) {
            res = this.makeOp(this.nodeManager.high(f), this.nodeManager.low(f), IntAlgorithm.ApplyOp.OP_OR);
        } else {
            int high = this.makeExquant(this.nodeManager.high(f), level);
            int low = this.makeExquant(this.nodeManager.low(f), level);
            res = this.makeNode(low, high, this.var(f));
        }
        this.cacheQuant(f, new int[]{level}, res);
        return res;
    }

    @Override
    public int restrict(int bdd, int var, boolean restrictionVar) {
        return this.var(bdd) != var ? bdd : (restrictionVar ? this.high(bdd) : this.low(bdd));
    }

    @Override
    public int makeCompose(int f1, int v, int f2) {
        if (this.level(f1) > this.nodeManager.level(v)) {
            return f1;
        }
        int res = this.checkCache(f1, v, f2, this.composeCache);
        if (res != -1) {
            return res;
        }
        if (this.var(f1) == v) {
            res = this.makeIte(f2, this.high(f1), this.low(f1));
        } else {
            int i = this.makeCompose(this.high(f1), v, f2);
            int e = this.makeCompose(this.low(f1), v, f2);
            res = this.makeIte(this.makeIthVar(this.var(f1)), i, e);
        }
        this.cacheCompose(f1, v, f2, res);
        return res;
    }

    @Override
    public int getCacheSize() {
        return this.opCache.size();
    }

    @Override
    public int getCacheNodeCount() {
        return this.opCache.nodeCount();
    }

    protected int makeIthVar(int var) {
        return this.makeNode(this.makeFalse(), this.makeTrue(), var);
    }

    protected int applyCheck(int f1, int f2, IntAlgorithm.ApplyOp op) {
        switch (op) {
            case OP_OR: {
                return this.orCheck(f1, f2);
            }
            case OP_AND: {
                return this.andCheck(f1, f2);
            }
            case OP_XOR: {
                return this.xorCheck(f1, f2);
            }
            case OP_NAND: {
                return this.nandCheck(f1, f2);
            }
            case OP_NOR: {
                return this.norCheck(f1, f2);
            }
            case OP_IMP: {
                return this.implyCheck(f1, f2);
            }
            case OP_XNOR: {
                return this.xnorCheck(f1, f2);
            }
        }
        if (this.isConst(f1) && this.isConst(f2)) {
            return baseOprResults[op.ordinal()][f1 << 1 | f2];
        }
        return this.opCacheLookup(f1, f2, op);
    }

    private int xorCheck(int f1, int f2) {
        if (f1 == f2) {
            return this.makeFalse();
        }
        if (this.isOne(f1)) {
            return this.makeNot(f2);
        }
        if (this.isOne(f2)) {
            return this.makeNot(f1);
        }
        if (this.isZero(f1)) {
            return f2;
        }
        if (this.isZero(f2)) {
            return f1;
        }
        return this.opCacheLookup(f1, f2, IntAlgorithm.ApplyOp.OP_XOR);
    }

    private int norCheck(int f1, int f2) {
        if (this.isOne(f1) || this.isOne(f2)) {
            return this.makeFalse();
        }
        if (this.isZero(f1) || f1 == f2) {
            return this.makeNot(f2);
        }
        if (this.isZero(f2)) {
            return this.makeNot(f1);
        }
        return this.opCacheLookup(f1, f2, IntAlgorithm.ApplyOp.OP_NOR);
    }

    private int xnorCheck(int f1, int f2) {
        if (f1 == f2) {
            return this.makeTrue();
        }
        if (this.isZero(f1)) {
            return this.makeNot(f2);
        }
        if (this.isZero(f2)) {
            return this.makeNot(f1);
        }
        if (this.isOne(f1)) {
            return f2;
        }
        if (this.isOne(f2)) {
            return f1;
        }
        return this.opCacheLookup(f1, f2, IntAlgorithm.ApplyOp.OP_XNOR);
    }

    private int nandCheck(int f1, int f2) {
        if (this.isZero(f1) || this.isZero(f2)) {
            return this.makeTrue();
        }
        if (this.isOne(f1) || f1 == f2) {
            return this.makeNot(f2);
        }
        if (this.isOne(f2)) {
            return this.makeNot(f1);
        }
        return this.opCacheLookup(f1, f2, IntAlgorithm.ApplyOp.OP_NAND);
    }

    private int implyCheck(int f1, int f2) {
        if (this.isZero(f1) || this.isOne(f2) || f1 == f2) {
            return this.makeTrue();
        }
        if (this.isOne(f1)) {
            return f2;
        }
        if (this.isZero(f2)) {
            return this.makeNot(f1);
        }
        return this.opCacheLookup(f1, f2, IntAlgorithm.ApplyOp.OP_IMP);
    }

    protected int andCheck(int f1, int f2) {
        if (f1 == f2) {
            return f1;
        }
        if (this.isZero(f1) || this.isZero(f2)) {
            return this.makeFalse();
        }
        if (this.isOne(f1)) {
            return f2;
        }
        if (this.isOne(f2)) {
            return f1;
        }
        return this.opCacheLookup(f1, f2, IntAlgorithm.ApplyOp.OP_AND);
    }

    protected int orCheck(int f1, int f2) {
        if (f1 == f2 || this.isZero(f2)) {
            return f1;
        }
        if (this.isOne(f1) || this.isOne(f2)) {
            return this.makeTrue();
        }
        if (this.isZero(f1)) {
            return f2;
        }
        return this.opCacheLookup(f1, f2, IntAlgorithm.ApplyOp.OP_OR);
    }

    protected int notCacheLookup(int root) {
        NotCacheData e = this.notCache.get(root);
        if (e == null || e.getInput() != root) {
            return -1;
        }
        return e.getResult();
    }

    protected int iteCacheLookup(int i, int t, int e) {
        return this.checkCache(i, t, e, this.iteCache);
    }

    protected int opCacheLookup(int f1, int f2, IntAlgorithm.ApplyOp op) {
        return this.checkCache(f1, f2, op.ordinal(), this.opCache);
    }

    protected void cacheApply(int f1, int f2, IntAlgorithm.ApplyOp op, int res) {
        this.cacheApply(f1, f2, op.ordinal(), res);
    }

    protected void cacheApply(int f1, int f2, int op, int res) {
        int hash = this.hash(f1, f2, op);
        this.nodeManager.addRefs(f1, f2, res);
        OpCacheData entry = this.opCache.createEntry(f1, f2, op, res);
        OpCacheData old = this.opCache.put(hash, entry);
        if (old != null) {
            this.nodeManager.freeRefs(old.f1(), old.f2(), old.f3());
        }
    }

    protected void cacheCompose(int f1, int v, int f2, int res) {
        int hash = this.hash(f1, v, f2);
        this.nodeManager.addRefs(f1, v, f2, res);
        OpCacheData entry = this.opCache.createEntry(f1, v, f2, res);
        OpCacheData old = this.opCache.put(hash, entry);
        if (old != null) {
            this.nodeManager.freeRefs(old.f1(), old.f2(), old.f3(), old.result());
        }
    }

    protected void cacheNot(int root, int res) {
        this.nodeManager.addRefs(root, res);
        NotCacheData old = this.notCache.put(root, res);
        if (old != null) {
            this.nodeManager.freeRefs(root, res);
        }
    }

    protected void cacheIte(int i, int t, int e, int res) {
        int applyHash = this.hash(i, t, e);
        this.nodeManager.addRefs(i, t, e, res);
        OpCacheData old = this.iteCache.put(applyHash, this.iteCache.createEntry(i, t, e, res));
        if (old != null) {
            this.nodeManager.freeRefs(old.f1(), old.f2(), old.f3(), old.result());
        }
    }

    protected void cacheQuant(int f, int[] levels, int res) {
        int applyHash = this.hash(f, levels[0]);
        this.nodeManager.addRefs(f, res);
        QuantCacheData old = this.quantCache.put(applyHash, this.quantCache.createEntry(f, levels, res));
        if (old != null) {
            this.nodeManager.freeRefs(old.f1(), old.result());
        }
    }

    protected int checkCache(int a, int b, int c, IntOpCache cache) {
        int hash = this.hash(a, b, c);
        OpCacheData data = cache.get(hash);
        if (data == null) {
            return -1;
        }
        if (data.f1() == a && data.f2() == b && data.f3() == c) {
            return data.result();
        }
        return -1;
    }

    protected int quantCheck(int f, int[] levels) {
        int hash = this.hash(f, levels[0]);
        QuantCacheData data = this.quantCache.get(hash);
        if (data == null) {
            return -1;
        }
        if (data.matches(f, levels)) {
            return data.result();
        }
        return -1;
    }

    protected int level(int r) {
        return this.nodeManager.level(this.var(r));
    }

    protected int topVarForLevels(int ... levels) {
        return this.nodeManager.varForLevel(Ints.min((int[])levels));
    }

    protected int restrictIf(int root, int var, int restrictWith) {
        return this.var(root) != var ? root : (this.isOne(restrictWith) ? this.high(root) : this.low(root));
    }

    protected int hash(int a, int b, int c) {
        return HashCodeGenerator.generateHashCode(a, b, c);
    }

    protected int hash(int a, int b) {
        return HashCodeGenerator.generateHashCode(a, b);
    }

    protected boolean isZero(int root) {
        return root == this.makeFalse();
    }

    protected boolean isOne(int root) {
        return root == this.makeTrue();
    }

    protected boolean isConst(int root) {
        return root <= this.makeTrue() && root >= this.makeFalse();
    }

    protected int low(int root) {
        return this.nodeManager.low(root);
    }

    protected int high(int root) {
        return this.nodeManager.high(root);
    }

    protected int var(int root) {
        return this.nodeManager.var(root);
    }
}

