/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.pjbdd.intBDD;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.stream.IntStream;
import org.sosy_lab.pjbdd.intBDD.IntNodeManager;
import org.sosy_lab.pjbdd.intBDD.IntUniqueTable;

public class IntBDDNodeManager
implements IntNodeManager {
    private int varCount;
    private int[] levelVar;
    private int[] varLevel;
    private List<Integer> varSet;
    private final IntUniqueTable uniqueTable;

    public IntBDDNodeManager(IntUniqueTable intUniqueTable) {
        this.uniqueTable = intUniqueTable;
    }

    @Override
    public int varForLevel(int level) {
        return level >= this.varCount ? this.varCount : this.levelVar[level];
    }

    @Override
    public void setVarCount(int count) {
        if (count < 1 || count <= this.varCount) {
            return;
        }
        int oldCount = this.varCount;
        this.varCount = count;
        if (this.varSet == null) {
            this.varSet = new ArrayList<Integer>();
        }
        if (this.levelVar == null) {
            this.levelVar = new int[this.varCount];
            this.varLevel = new int[this.varCount];
        } else {
            int[] newLevelVar = new int[this.varCount];
            int[] newVarLevel = new int[this.varCount];
            System.arraycopy(this.levelVar, 0, newLevelVar, 0, this.levelVar.length);
            System.arraycopy(this.varLevel, 0, newVarLevel, 0, this.levelVar.length);
            this.levelVar = newLevelVar;
            this.varLevel = newVarLevel;
        }
        while (oldCount < count) {
            this.varSet.add(this.makeNode(oldCount, 0, 1));
            this.varSet.add(this.makeNode(oldCount, 1, 0));
            this.setMaxRef(this.varSet.get(oldCount * 2));
            this.setMaxRef(this.varSet.get(oldCount * 2 + 1));
            this.levelVar[oldCount] = oldCount;
            this.varLevel[oldCount] = oldCount;
            ++oldCount;
        }
    }

    @Override
    public int getVarCount() {
        return this.varCount;
    }

    @Override
    public int[] getCurrentOrdering() {
        return Arrays.copyOf(this.levelVar, this.levelVar.length);
    }

    @Override
    public boolean checkLvl(int level) {
        return level < this.varCount;
    }

    @Override
    public void setVarOrdering(int ... order) {
        IntStream.range(0, order.length).forEach(i -> {
            if (order[i] != this.levelVar[i]) {
                this.swapVarToLevel(order[i], i);
            }
        });
    }

    @Override
    public int level(int variable) {
        return variable >= this.varCount || variable < 0 ? this.varCount : this.varLevel[variable];
    }

    @Override
    public void setMaxRef(int root) {
        this.uniqueTable.setMaxRef(root);
    }

    @Override
    public void swap(int upper, int lower) {
        this.uniqueTable.swap(upper, lower, this::makeNode);
    }

    private void swapVarToLevel(int var, int level) {
        int levelOfVar = this.varLevel[var];
        while (levelOfVar != level) {
            if (levelOfVar < level) {
                this.swapLevel(levelOfVar++, levelOfVar);
                continue;
            }
            this.swapLevel(levelOfVar--, levelOfVar);
        }
    }

    @Override
    public int makeVariableBefore(int var) {
        int newVariable = this.getVarCount();
        int newNode = this.makeNode(newVariable, this.getFalse(), this.getTrue());
        int newLevel = this.level(var);
        int i = this.levelVar.length - 2;
        while (i + 1 > newLevel) {
            int newVarIndex = this.levelVar[i];
            this.levelVar[i + 1] = this.levelVar[i];
            this.varLevel[newVarIndex] = i + 1;
            --i;
        }
        this.levelVar[newLevel] = newVariable;
        this.varLevel[newVariable] = newLevel;
        return newNode;
    }

    @Override
    public void cleanUnusedNodes() {
        this.uniqueTable.cleanUnusedNodes();
    }

    private void swapLevel(int levelA, int levelB) {
        int varA = this.levelVar[levelA];
        int varB = this.levelVar[levelB];
        this.varLevel[varA] = levelB;
        this.varLevel[varB] = levelA;
        this.levelVar[levelB] = varA;
        this.levelVar[levelA] = varB;
        this.swap(varA, varB);
    }

    @Override
    public void addRefs(int ... roots) {
        this.uniqueTable.incRef(roots);
    }

    @Override
    public void freeRefs(int ... roots) {
        this.uniqueTable.decRef(roots);
    }

    @Override
    public int makeNode(int var, int low, int high) {
        if (low == high) {
            return low;
        }
        if (!this.checkLvl(var)) {
            this.setVarCount(var + 1);
        }
        this.uniqueTable.incRef(low, high);
        int res = this.uniqueTable.getOrCreate(var, low, high);
        this.addRefs(res);
        this.freeRefs(low, high);
        return res;
    }

    @Override
    public int low(int r) {
        return this.uniqueTable.getLow(r);
    }

    @Override
    public int high(int r) {
        return this.uniqueTable.getHigh(r);
    }

    @Override
    public int var(int root) {
        return this.uniqueTable.getVariable(root);
    }

    @Override
    public int getFalse() {
        return 0;
    }

    @Override
    public int getTrue() {
        return 1;
    }

    @Override
    public IntUniqueTable getNodeTable() {
        return this.uniqueTable;
    }

    @Override
    public int getNodeCount() {
        return this.uniqueTable.getNodeCount();
    }

    @Override
    public int getUniqueTableSize() {
        return this.uniqueTable.getSize();
    }
}

