/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.pjbdd.intBDD;

import java.lang.ref.Reference;
import org.sosy_lab.pjbdd.api.DD;
import org.sosy_lab.pjbdd.intBDD.IntAlgorithm;
import org.sosy_lab.pjbdd.intBDD.IntNodeManager;
import org.sosy_lab.pjbdd.intBDD.IntSatAlgorithm;
import org.sosy_lab.pjbdd.intBDD.SerialIntCreator;
import org.sosy_lab.pjbdd.util.reference.IntHoldingWeakReference;
import org.sosy_lab.pjbdd.util.reference.ReclaimedReferenceCleaningThread;

public class IntCreator
extends SerialIntCreator {
    private final CleanUpThread cleaner = new CleanUpThread();

    public IntCreator(IntAlgorithm algorithm, IntSatAlgorithm satAlgorithm, IntNodeManager nodeManager) {
        super(algorithm, satAlgorithm, nodeManager);
        this.startCleaner();
    }

    protected void startCleaner() {
        this.cleaner.start();
    }

    @Override
    public void shutDown() {
        this.algorithm.shutDown();
        this.cleaner.shutdown();
    }

    @Override
    protected DD makeBDD(int id) {
        SerialIntCreator.BDDimpl bdd = new SerialIntCreator.BDDimpl(this, id);
        new IntHoldingWeakReference<SerialIntCreator.BDDimpl>(bdd, this.queue, id);
        return bdd;
    }

    public String toString() {
        return this.getClass().getSimpleName();
    }

    private class CleanUpThread
    extends ReclaimedReferenceCleaningThread {
        private CleanUpThread() {
        }

        @Override
        protected void deleteReclaimedEntries() throws InterruptedException {
            Reference sv = IntCreator.this.queue.remove(1000L);
            if (sv != null && sv instanceof IntHoldingWeakReference && !this.isShutdown()) {
                IntCreator.this.freeRef(((IntHoldingWeakReference)sv).intValue());
            }
        }
    }
}

