/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.pjbdd.intBDD;

import java.math.BigInteger;
import org.sosy_lab.pjbdd.core.cache.Cache;
import org.sosy_lab.pjbdd.intBDD.IntNodeManager;

public class IntSatAlgorithm {
    private final IntNodeManager nodeManager;
    private final Cache<Integer, BigInteger> satCache;

    public IntSatAlgorithm(IntNodeManager nodeManager, Cache<Integer, BigInteger> satCache) {
        this.nodeManager = nodeManager;
        this.satCache = satCache;
    }

    public int anySat(int root) {
        if (this.isConst(root)) {
            return root;
        }
        if (this.nodeManager.getFalse() == this.low(root)) {
            return this.nodeManager.makeNode(this.var(root), this.nodeManager.getFalse(), this.anySat(this.high(root)));
        }
        return this.nodeManager.makeNode(this.var(root), this.anySat(this.low(root)), this.nodeManager.getFalse());
    }

    public BigInteger satCount(int root) {
        return BigInteger.valueOf(2L).pow(this.level(root)).multiply(this.satCountRec(root));
    }

    private BigInteger satCountRec(int root) {
        if (this.isConst(root)) {
            return BigInteger.valueOf(root);
        }
        BigInteger cached = this.satCache.get(root);
        if (cached != null) {
            return cached;
        }
        if (this.low(root) == -1) {
            System.out.println("low: " + root);
        }
        if (this.high(root) == -1) {
            System.out.println("high: " + root);
        }
        BigInteger s = BigInteger.valueOf(2L).pow(this.level(this.low(root)) - this.level(root) - 1);
        BigInteger size = s.multiply(this.satCountRec(this.low(root)));
        s = BigInteger.valueOf(2L).pow(this.level(this.high(root)) - this.level(root) - 1);
        size = size.add(s.multiply(this.satCountRec(this.high(root))));
        this.satCache.put(root, size);
        return size;
    }

    private int level(int root) {
        return this.nodeManager.level(this.var(root));
    }

    private int var(int root) {
        return this.nodeManager.var(root);
    }

    private int high(int root) {
        return this.nodeManager.high(root);
    }

    private int low(int root) {
        return this.nodeManager.low(root);
    }

    private boolean isConst(int root) {
        return root == this.nodeManager.getFalse() || root == this.nodeManager.getTrue();
    }
}

