/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.pjbdd.intBDD;

import java.util.function.IntConsumer;
import java.util.stream.IntStream;
import org.sosy_lab.pjbdd.intBDD.IntUniqueTable;
import org.sosy_lab.pjbdd.util.HashCodeGenerator;
import org.sosy_lab.pjbdd.util.PrimeUtils;

public class IntUniqueTableImpl
implements IntUniqueTable {
    protected static final int OFFSET_VAR = 0;
    protected static final int OFFSET_LOW = 1;
    protected static final int OFFSET_HIGH = 2;
    protected static final int OFFSET_HASH = 3;
    protected static final int OFFSET_NEXT = 4;
    protected static final int OFFSET_REF_COUNT = 5;
    protected static final int MAX_REF = -1;
    protected final int nodeSize;
    protected int[] table;
    protected final boolean disableGC;
    protected final int maxSize;
    protected int nextFree;
    protected int freeCounter;
    protected int nodeCount;
    protected final int increaseFactor;

    public IntUniqueTableImpl(int initialSize, int increaseFactor, boolean disableGC) {
        this.maxSize = Integer.MAX_VALUE / (disableGC ? 5 : 6);
        this.disableGC = disableGC;
        this.nodeSize = disableGC ? 5 : 6;
        this.nodeCount = PrimeUtils.getGreaterNextPrime(initialSize);
        this.increaseFactor = increaseFactor;
        this.table = new int[this.nodeCount * this.nodeSize];
        for (int n = 2; n < this.nodeCount; ++n) {
            this.setLow(n, -1);
            this.setNext(n, n + 1);
        }
        this.setNext(this.nodeCount - 1, 0);
        this.setMaxRef(0);
        this.setMaxRef(1);
        this.setLow(0, 0);
        this.setHigh(0, 0);
        this.setVariable(0, -1);
        this.setLow(1, 1);
        this.setHigh(1, 1);
        this.setVariable(1, -2);
        this.nextFree = 2;
        this.freeCounter = this.nodeCount - 2;
    }

    @Override
    public int getOrCreate(int var, int low, int high) {
        int res;
        this.tryResizing();
        int hash = this.hashNode(var, low, high);
        int head = res = this.getNodeWithHash(hash);
        while (res != 0) {
            if (this.getVariable(res) == var && this.getLow(res) == low && this.getHigh(res) == high) {
                return res;
            }
            res = this.getNext(res);
        }
        res = this.getNextFree();
        if (res < 2) {
            this.tryResizing();
            return this.getOrCreate(var, low, high);
        }
        this.createNode(res, low, high, var, hash, head);
        return res;
    }

    protected int getNextFree() {
        int next = this.nextFree;
        this.nextFree = this.getNext(next);
        return next;
    }

    protected boolean createNode(int node, int low, int high, int var, int hash, int head) {
        this.setHash(hash, node);
        this.setNext(node, head);
        this.setVariable(node, var);
        this.setLow(node, low);
        this.setHigh(node, high);
        --this.freeCounter;
        return true;
    }

    @Override
    public void printStats() {
        throw new UnsupportedOperationException("Statistic printing not yet implemented");
    }

    protected boolean checkResize() {
        return this.nextFree <= 1;
    }

    private void tryResizing() {
        if (this.checkResize()) {
            this.resizeTable();
        }
    }

    protected void resizeTable() {
        int oldSize = this.nodeCount;
        int newSize = this.nodeCount;
        newSize = this.increaseFactor > 0 ? (newSize += newSize * this.increaseFactor) : (newSize <<= 1);
        if (newSize > this.maxSize) {
            newSize = this.maxSize;
        }
        this.doResize(oldSize, newSize);
    }

    protected void doResize(int oldSize, int newSize) {
        int n;
        if (oldSize < (newSize = PrimeUtils.getLowerNextPrime(newSize))) {
            int[] newUniqueTable = new int[newSize * this.nodeSize];
            System.arraycopy(this.table, 0, newUniqueTable, 0, this.table.length);
            this.table = newUniqueTable;
        }
        this.nodeCount = newSize;
        boolean[] marks = this.markTable(oldSize);
        for (n = 0; n < oldSize; ++n) {
            if (!marks[n] && !this.disableGC) {
                this.setLow(n, -1);
            }
            this.setHash(n, 0);
            this.setNext(n, 0);
        }
        for (n = oldSize; n < this.nodeCount; ++n) {
            this.setLow(n, -1);
        }
        this.rehash();
    }

    private boolean[] markTable(int oldsize) {
        boolean[] marks = new boolean[oldsize];
        if (!this.disableGC) {
            for (int i = oldsize - 1; i >= 0; --i) {
                if (!this.hasRef(i)) continue;
                this.markNode(i, marks);
            }
        }
        return marks;
    }

    private void markNode(int i, boolean[] marks) {
        if (!marks[i]) {
            marks[i] = true;
            this.markNode(this.getHigh(i), marks);
            this.markNode(this.getLow(i), marks);
        }
    }

    private void rehash() {
        this.nextFree = 0;
        this.freeCounter = this.nodeCount;
        for (int n = this.nodeCount - 1; n >= 2; --n) {
            if (this.getLow(n) != -1) {
                int hash = this.hashNode(this.getVariable(n), this.getLow(n), this.getHigh(n));
                this.setNext(n, this.getNodeWithHash(hash));
                this.setHash(hash, n);
                --this.freeCounter;
                continue;
            }
            this.setNext(n, this.nextFree);
            this.nextFree = n;
        }
    }

    @Override
    public void setMaxRef(int node) {
        if (!this.disableGC) {
            this.table[node * this.nodeSize + 5] = -1;
        }
    }

    @Override
    public void clear() {
        this.table = null;
        this.table = new int[this.nodeCount * this.nodeSize];
    }

    @Override
    public void forEach(IntConsumer function) {
        IntStream.range(0, this.nodeCount).forEach(i -> {
            if (this.getLow(i) != -1) {
                function.accept(i);
            }
        });
    }

    @Override
    public void swap(int upper, int lower, IntUniqueTable.NodeMaker delegate) {
        this.forEach(bdd -> {
            if (this.getVariable(bdd) == lower) {
                int oldHash = this.hashNode(bdd);
                int low = this.getLow(bdd);
                int high = this.getHigh(bdd);
                if (this.getVariable(low) == upper || this.getVariable(high) == upper) {
                    int low0 = low;
                    int low1 = low;
                    int high0 = high;
                    int high1 = high;
                    if (this.getVariable(low) == upper) {
                        low0 = this.getLow(low);
                        low1 = this.getHigh(low);
                    }
                    if (this.getVariable(high) == upper) {
                        high0 = this.getLow(high);
                        high1 = this.getHigh(high);
                    }
                    low = delegate.makeNode(lower, low0, high0);
                    high = delegate.makeNode(lower, low1, high1);
                    this.decRef(this.getHigh(bdd));
                    this.decRef(this.getLow(bdd));
                    this.setVariable(bdd, upper);
                    this.setHigh(bdd, high);
                    this.setLow(bdd, low);
                    this.rehash(bdd, oldHash);
                }
            }
        });
    }

    @Override
    public int getSize() {
        return this.nodeCount;
    }

    @Override
    public void cleanUnusedNodes() {
        this.doResize(this.nodeCount, this.nodeCount);
    }

    private void rehash(int bdd, int oldHash) {
        int newHash = this.hashNode(bdd);
        if (oldHash != newHash) {
            int res;
            int previous = res = this.getNodeWithHash(oldHash);
            while (res != bdd) {
                previous = res;
                res = this.getNext(res);
            }
            if (previous == res) {
                this.setHash(oldHash, this.getNext(res));
            } else {
                this.setNext(previous, this.getNext(res));
            }
            this.setNext(bdd, this.getNodeWithHash(newHash));
            this.setHash(newHash, bdd);
        }
    }

    @Override
    public void incRef(int ... roots) {
        if (this.disableGC) {
            return;
        }
        for (int r : roots) {
            if (this.table[r * this.nodeSize + 5] == -1) continue;
            int n = r * this.nodeSize + 5;
            this.table[n] = this.table[n] + 1;
        }
    }

    @Override
    public void setVariable(int node, int val) {
        this.table[node * this.nodeSize + 0] = val;
    }

    @Override
    public int getHigh(int r) {
        if (r <= 1) {
            return r;
        }
        return this.table[r * this.nodeSize + 2];
    }

    @Override
    public int getLow(int r) {
        if (r <= 1) {
            return r;
        }
        return this.table[r * this.nodeSize + 1];
    }

    @Override
    public int getVariable(int node) {
        return this.table[node * this.nodeSize + 0];
    }

    @Override
    public int getNodeCount() {
        return this.nodeCount - this.freeCounter;
    }

    @Override
    public void decRef(int ... roots) {
        if (this.disableGC) {
            return;
        }
        for (int r : roots) {
            int old = this.table[r * this.nodeSize + 5];
            if (old <= 0) continue;
            int n = r * this.nodeSize + 5;
            this.table[n] = this.table[n] - 1;
        }
    }

    protected boolean hasRef(int r) {
        return this.table[r * this.nodeSize + 5] != 0;
    }

    protected int hashNode(int index) {
        return this.hashNode(this.getVariable(index), this.getLow(index), this.getHigh(index));
    }

    protected void setLow(int root, int low) {
        this.table[root * this.nodeSize + 1] = low;
    }

    protected void setHigh(int root, int high) {
        this.table[root * this.nodeSize + 2] = high;
    }

    protected int getNodeWithHash(int hash) {
        return this.table[hash * this.nodeSize + 3];
    }

    protected boolean setHash(int hash, int index) {
        this.table[hash * this.nodeSize + 3] = index;
        return true;
    }

    protected int getNext(int root) {
        return this.table[root * this.nodeSize + 4];
    }

    protected void setNext(int root, int next) {
        this.table[root * this.nodeSize + 4] = next;
    }

    protected int hashNode(int lvl, int low, int high) {
        return Math.abs(HashCodeGenerator.generateHashCode(lvl, low, high) % this.nodeCount);
    }
}

