/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.pjbdd.intBDD;

import java.util.concurrent.ForkJoinPool;
import java.util.concurrent.ForkJoinTask;
import java.util.concurrent.ForkJoinWorkerThread;
import java.util.concurrent.Future;
import org.sosy_lab.pjbdd.intBDD.IntAlgorithm;
import org.sosy_lab.pjbdd.intBDD.IntBDDAlgorithm;
import org.sosy_lab.pjbdd.intBDD.IntNodeManager;
import org.sosy_lab.pjbdd.intBDD.cache.IntNotCache;
import org.sosy_lab.pjbdd.intBDD.cache.IntOpCache;
import org.sosy_lab.pjbdd.intBDD.cache.IntQuantCache;

public class ParallelIntAlgorithm
extends IntBDDAlgorithm {
    private final ForkJoinPool pool;

    public ParallelIntAlgorithm(IntOpCache opCache, IntOpCache iteCache, IntNotCache notCache, IntQuantCache quantCache, IntOpCache composeCache, IntNodeManager nodeManager, int threads) {
        super(opCache, iteCache, notCache, quantCache, composeCache, nodeManager);
        this.pool = new ForkJoinPool(threads, new Factory(), null, false);
    }

    @Override
    public int makeOp(int f1, int f2, IntAlgorithm.ApplyOp op) {
        return this.pool.submit(new FJTask(f1, f2, op)).join();
    }

    @Override
    protected int expandExquant(int fLow, int fHigh, int[] f2, int var) {
        Future high = this.pool.submit(() -> this.makeExquant(fHigh, f2));
        Future low = this.pool.submit(() -> this.makeExquant(fLow, f2));
        return this.makeNode((Integer)((ForkJoinTask)low).join(), (Integer)((ForkJoinTask)high).join(), var);
    }

    @Override
    public void shutDown() {
        super.shutDown();
        this.pool.shutdown();
    }

    static class Factory
    implements ForkJoinPool.ForkJoinWorkerThreadFactory {
        Factory() {
        }

        @Override
        public ForkJoinWorkerThread newThread(ForkJoinPool fjPool) {
            return new ApplyWorker(fjPool);
        }
    }

    public static class ApplyWorker
    extends ForkJoinWorkerThread {
        protected ApplyWorker(ForkJoinPool pool) {
            super(pool);
        }
    }

    public class FJTask
    extends ForkJoinTask<Integer> {
        private static final long serialVersionUID = 1873627492814886644L;
        private final IntAlgorithm.ApplyOp op;
        private final int arg1;
        private final int arg2;
        private int res;

        public FJTask(int f1, int f2, IntAlgorithm.ApplyOp op) {
            ParallelIntAlgorithm.this.nodeManager.addRefs(f1, f2);
            this.arg1 = f1;
            this.arg2 = f2;
            this.op = op;
        }

        @Override
        public Integer getRawResult() {
            return this.res;
        }

        @Override
        protected void setRawResult(Integer value) {
            this.res = value;
        }

        @Override
        protected boolean exec() {
            if (Thread.currentThread() instanceof ApplyWorker) {
                this.res = ParallelIntAlgorithm.this.applyCheck(this.arg1, this.arg2, this.op);
                if (this.res != -1) {
                    return true;
                }
                this.res = this.apply(this.arg1, this.arg2);
                return true;
            }
            return false;
        }

        private int apply(int f1, int f2) {
            int topVar = ParallelIntAlgorithm.this.topVarForLevels(ParallelIntAlgorithm.this.level(f1), ParallelIntAlgorithm.this.level(f2));
            int lowF1 = ParallelIntAlgorithm.this.level(f1) <= ParallelIntAlgorithm.this.level(f2) ? ParallelIntAlgorithm.this.low(f1) : f1;
            int lowF2 = ParallelIntAlgorithm.this.level(f2) <= ParallelIntAlgorithm.this.level(f1) ? ParallelIntAlgorithm.this.low(f2) : f2;
            int highF1 = ParallelIntAlgorithm.this.level(f1) <= ParallelIntAlgorithm.this.level(f2) ? ParallelIntAlgorithm.this.high(f1) : f1;
            int highF2 = ParallelIntAlgorithm.this.level(f2) <= ParallelIntAlgorithm.this.level(f1) ? ParallelIntAlgorithm.this.high(f2) : f2;
            ParallelIntAlgorithm.this.applyCheck(lowF1, lowF2, this.op);
            int high = ParallelIntAlgorithm.this.applyCheck(highF1, highF2, this.op);
            int low = ParallelIntAlgorithm.this.applyCheck(lowF1, lowF2, this.op);
            if (low == -1 && high == -1) {
                ForkJoinTask task = new FJTask(lowF1, lowF2, this.op).fork();
                high = this.apply(highF1, highF2);
                low = (Integer)task.join();
            }
            if (low == -1) {
                low = this.apply(lowF1, lowF2);
            }
            if (high == -1) {
                high = this.apply(highF1, highF2);
            }
            this.res = ParallelIntAlgorithm.this.makeNode(low, high, topVar);
            ParallelIntAlgorithm.this.cacheApply(f1, f2, this.op, this.res);
            return this.res;
        }
    }
}

