/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.pjbdd.intBDD;

import java.lang.ref.Reference;
import java.lang.ref.ReferenceQueue;
import java.math.BigInteger;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;
import javax.annotation.Nullable;
import org.sosy_lab.pjbdd.api.Creator;
import org.sosy_lab.pjbdd.api.DD;
import org.sosy_lab.pjbdd.intBDD.IntAlgorithm;
import org.sosy_lab.pjbdd.intBDD.IntNodeManager;
import org.sosy_lab.pjbdd.intBDD.IntSatAlgorithm;
import org.sosy_lab.pjbdd.util.BDDCreatorSimpleStats;
import org.sosy_lab.pjbdd.util.IfThenElseData;
import org.sosy_lab.pjbdd.util.IntArrayUtils;
import org.sosy_lab.pjbdd.util.reference.IntHoldingWeakReference;

public class SerialIntCreator
implements Creator {
    protected final ReferenceQueue<BDDimpl> queue = new ReferenceQueue();
    protected final IntSatAlgorithm satAlgorithm;
    protected final IntAlgorithm algorithm;
    protected final IntNodeManager nodeManager;
    @Nullable
    protected Creator.Stats stats;

    public SerialIntCreator(IntAlgorithm algorithm, IntSatAlgorithm satAlgorithm, IntNodeManager nodeManager) {
        this.algorithm = algorithm;
        this.satAlgorithm = satAlgorithm;
        this.nodeManager = nodeManager;
    }

    @Override
    public DD restrict(DD bdd, int var, boolean restrictionVar) {
        throw new IllegalArgumentException();
    }

    @Override
    public DD anySat(DD f) {
        return this.makeBDD(this.satAlgorithm.anySat(((BDDimpl)f).index));
    }

    @Override
    public BigInteger satCount(DD f) {
        return this.satAlgorithm.satCount(((BDDimpl)f).index);
    }

    @Override
    public DD makeTrue() {
        return this.makeBDD(1);
    }

    @Override
    public DD makeFalse() {
        return this.makeBDD(0);
    }

    @Override
    public DD makeIte(DD f1, DD f2, DD f3) {
        return this.makeBDD(this.algorithm.makeIte(((BDDimpl)f1).index, ((BDDimpl)f2).index, ((BDDimpl)f3).index));
    }

    @Override
    public DD makeVariable() {
        return this.makeBDD(this.nodeManager.makeNode(this.nodeManager.getVarCount(), this.nodeManager.getFalse(), this.nodeManager.getTrue()));
    }

    @Override
    public DD makeVariableBefore(DD var) {
        return this.makeBDD(this.nodeManager.makeVariableBefore(var.getVariable()));
    }

    @Override
    public DD makeNot(DD f) {
        return this.makeBDD(this.algorithm.makeNot(((BDDimpl)f).index));
    }

    @Override
    public DD makeAnd(DD f1, DD f2) {
        return this.makeBDD(this.algorithm.makeOp(((BDDimpl)f1).index, ((BDDimpl)f2).index, IntAlgorithm.ApplyOp.OP_AND));
    }

    @Override
    public DD makeOr(DD f1, DD f2) {
        return this.makeBDD(this.algorithm.makeOp(((BDDimpl)f1).index, ((BDDimpl)f2).index, IntAlgorithm.ApplyOp.OP_OR));
    }

    @Override
    public DD makeXor(DD f1, DD f2) {
        return this.makeBDD(this.algorithm.makeOp(((BDDimpl)f1).index, ((BDDimpl)f2).index, IntAlgorithm.ApplyOp.OP_XOR));
    }

    @Override
    public DD makeNor(DD f1, DD f2) {
        return this.makeBDD(this.algorithm.makeOp(((BDDimpl)f1).index, ((BDDimpl)f2).index, IntAlgorithm.ApplyOp.OP_NOR));
    }

    @Override
    public DD makeNand(DD f1, DD f2) {
        return this.makeBDD(this.algorithm.makeOp(((BDDimpl)f1).index, ((BDDimpl)f2).index, IntAlgorithm.ApplyOp.OP_NAND));
    }

    @Override
    public DD makeExists(DD f1, DD[] f2) {
        int f = ((BDDimpl)f2[0]).index;
        for (DD arg : f2) {
            f = this.algorithm.makeOp(f, ((BDDimpl)arg).index, IntAlgorithm.ApplyOp.OP_AND);
        }
        Set<Integer> varSet = this.createHighVarLevelSet(f);
        return this.makeBDD(this.algorithm.makeExquant(((BDDimpl)f1).index, IntArrayUtils.toIntArray(varSet)));
    }

    @Override
    public DD makeExists(DD f1, DD f2) {
        Set<Integer> varSet = this.createHighVarLevelSet(((BDDimpl)f2).index);
        return this.makeBDD(this.algorithm.makeExquant(((BDDimpl)f1).index, IntArrayUtils.toIntArray(varSet)));
    }

    @Override
    public DD makeReplace(DD f1, DD oldVar, DD replaceVar) {
        return this.makeExists(this.makeAnd(f1, this.makeXnor(oldVar, replaceVar)), oldVar);
    }

    @Override
    public DD makeCompose(DD f1, int var, DD f2) {
        return this.makeBDD(this.algorithm.makeCompose(((BDDimpl)f1).index, var, ((BDDimpl)f2).index));
    }

    @Override
    public DD makeXnor(DD f1, DD f2) {
        return this.makeBDD(this.algorithm.makeOp(((BDDimpl)f1).index, ((BDDimpl)f2).index, IntAlgorithm.ApplyOp.OP_XNOR));
    }

    @Override
    public DD makeEqual(DD f1, DD f2) {
        return this.makeXnor(f1, f2);
    }

    @Override
    public DD makeUnequal(DD f1, DD f2) {
        return this.makeXor(f1, f2);
    }

    @Override
    public DD makeImply(DD f1, DD f2) {
        return this.makeBDD(this.algorithm.makeOp(((BDDimpl)f1).index, ((BDDimpl)f2).index, IntAlgorithm.ApplyOp.OP_IMP));
    }

    @Override
    public IfThenElseData getIfThenElse(DD f) {
        return new IfThenElseData(this.makeIthVar(f.getVariable()), f.getLow(), f.getHigh());
    }

    @Override
    public DD makeNode(DD low, DD high, int var) {
        return this.makeBDD(this.nodeManager.makeNode(var, ((BDDimpl)low).index, ((BDDimpl)high).index));
    }

    @Override
    public DD getLow(DD top) {
        return this.makeBDD(this.low(((BDDimpl)top).index));
    }

    @Override
    public DD getHigh(DD top) {
        return this.makeBDD(this.high(((BDDimpl)top).index));
    }

    @Override
    public void shutDown() {
        this.algorithm.shutDown();
    }

    @Override
    public int getVariableCount() {
        return this.nodeManager.getVarCount();
    }

    @Override
    public int[] getVariableOrdering() {
        return this.nodeManager.getCurrentOrdering();
    }

    @Override
    public void setVariableCount(int count) {
        this.nodeManager.setVarCount(this.var(count));
    }

    @Override
    public void setVarOrder(List<Integer> pOrder) {
        this.nodeManager.setVarOrdering(pOrder.stream().mapToInt(i -> i).toArray());
    }

    @Override
    public Creator.Stats getCreatorStats() {
        if (this.stats == null) {
            int uniqueTableNodeCount = this.nodeManager.getNodeCount();
            int uniqueTableSize = this.nodeManager.getUniqueTableSize();
            int variableCount = this.nodeManager.getVarCount();
            int cacheSize = this.algorithm.getCacheSize();
            int cacheNodeCount = this.algorithm.getCacheNodeCount();
            return new BDDCreatorSimpleStats(uniqueTableSize, uniqueTableNodeCount, cacheSize, cacheNodeCount, variableCount);
        }
        return this.stats;
    }

    @Override
    public void cleanUnusedNodes() {
        this.nodeManager.cleanUnusedNodes();
    }

    protected DD makeBDD(int id) {
        BDDimpl bdd = new BDDimpl(id);
        new IntHoldingWeakReference<BDDimpl>(bdd, this.queue, id);
        this.deleteReclaimedEntries();
        return bdd;
    }

    private Set<Integer> createHighVarLevelSet(int f) {
        TreeSet<Integer> varLevelSet = new TreeSet<Integer>();
        while (this.nodeManager.getTrue() != f && this.nodeManager.getFalse() != f) {
            varLevelSet.add(this.level(f));
            f = this.high(f);
        }
        return varLevelSet;
    }

    protected void addRef(int index) {
        this.nodeManager.addRefs(index);
    }

    protected void freeRef(int index) {
        this.nodeManager.freeRefs(index);
    }

    protected int low(int root) {
        return this.nodeManager.low(root);
    }

    protected int high(int root) {
        return this.nodeManager.high(root);
    }

    protected int var(int index) {
        return this.nodeManager.var(index);
    }

    protected int level(int index) {
        return this.nodeManager.level(this.var(index));
    }

    protected void deleteReclaimedEntries() {
        Reference<BDDimpl> sv = this.queue.poll();
        while (sv != null) {
            if (sv instanceof IntHoldingWeakReference) {
                this.freeRef(((IntHoldingWeakReference)sv).intValue());
            }
            sv = this.queue.poll();
        }
    }

    class BDDimpl
    implements DD {
        final int index;

        BDDimpl(int index) {
            this.index = index;
            SerialIntCreator.this.addRef(this.index);
        }

        public DD not() {
            return SerialIntCreator.this.makeNot(this);
        }

        @Override
        public int getVariable() {
            return SerialIntCreator.this.var(this.index);
        }

        @Override
        public DD getLow() {
            return SerialIntCreator.this.makeBDD(SerialIntCreator.this.low(this.index));
        }

        @Override
        public DD getHigh() {
            return SerialIntCreator.this.makeBDD(SerialIntCreator.this.high(this.index));
        }

        @Override
        public boolean isTrue() {
            return this.index == 1;
        }

        @Override
        public boolean isFalse() {
            return this.index == 0;
        }

        @Override
        public boolean equals(Object o) {
            if (o instanceof BDDimpl) {
                return ((BDDimpl)o).index == this.index;
            }
            return false;
        }

        @Override
        public int hashCode() {
            return this.index;
        }
    }
}

