/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.pjbdd.intBDD.cache;

import java.lang.invoke.MethodHandles;
import java.lang.invoke.VarHandle;
import org.sosy_lab.pjbdd.intBDD.cache.IntNotCache;
import org.sosy_lab.pjbdd.intBDD.cache.NotCacheData;

public class CASIntNotCache
extends IntNotCache {
    private final VarHandle arrayHandle = MethodHandles.arrayElementVarHandle(NotCacheData[].class);

    public CASIntNotCache(int size) {
        super(size);
    }

    @Override
    public NotCacheData get(int hash) {
        int index = Math.abs(hash % this.table.length);
        return this.arrayHandle.get(this.table, index);
    }

    @Override
    public NotCacheData put(int input, int res) {
        int index = Math.abs(input % this.table.length);
        NotCacheData old = this.arrayHandle.get(this.table, index);
        NotCacheData data = new NotCacheData(input, res);
        while (!this.arrayHandle.weakCompareAndSet(this.table, index, old, data)) {
            old = this.arrayHandle.get(this.table, index);
            if (old != data) continue;
            throw new IllegalStateException("CAS FAILED SPURIOSLY");
        }
        return old;
    }
}

