/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.pjbdd.intBDD.cache;

import java.lang.invoke.MethodHandles;
import java.lang.invoke.VarHandle;
import org.sosy_lab.pjbdd.intBDD.cache.IntOpCache;
import org.sosy_lab.pjbdd.intBDD.cache.OpCacheData;

public class CASIntOpCache
extends IntOpCache {
    private final VarHandle arrayHandle = MethodHandles.arrayElementVarHandle(OpCacheData[].class);

    public CASIntOpCache(int size) {
        super(size);
    }

    @Override
    public OpCacheData get(int hash) {
        int index = Math.abs(hash % this.table.length);
        return this.arrayHandle.get(this.table, index);
    }

    @Override
    public OpCacheData put(int hash, OpCacheData data) {
        int index = Math.abs(hash % this.table.length);
        OpCacheData old = this.arrayHandle.get(this.table, index);
        while (!this.arrayHandle.weakCompareAndSet(this.table, index, old, data)) {
            old = this.arrayHandle.get(this.table, index);
            if (old != data) continue;
            throw new IllegalStateException("CAS FAILED SPURIOSLY");
        }
        return old;
    }
}

