/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.pjbdd.intBDD.cache;

import java.lang.invoke.MethodHandles;
import java.lang.invoke.VarHandle;
import org.sosy_lab.pjbdd.intBDD.cache.IntQuantCache;
import org.sosy_lab.pjbdd.intBDD.cache.QuantCacheData;

public class CASIntQuantCache
extends IntQuantCache {
    private final VarHandle arrayHandle = MethodHandles.arrayElementVarHandle(QuantCacheData[].class);

    public CASIntQuantCache(int size) {
        super(size);
    }

    @Override
    public QuantCacheData get(int hash) {
        int index = Math.abs(hash % this.table.length);
        return this.arrayHandle.get(this.table, index);
    }

    @Override
    public QuantCacheData put(int hash, QuantCacheData data) {
        int index = Math.abs(hash % this.table.length);
        QuantCacheData old = this.arrayHandle.get(this.table, index);
        while (!this.arrayHandle.weakCompareAndSet(this.table, index, old, data)) {
            old = this.arrayHandle.get(this.table, index);
            if (old != data) continue;
            throw new IllegalStateException("CAS FAILED SPURIOSLY");
        }
        return old;
    }
}

