/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.pjbdd.intBDD.cache;

import java.util.Arrays;
import java.util.Objects;
import java.util.stream.IntStream;
import org.sosy_lab.pjbdd.intBDD.cache.NotCacheData;
import org.sosy_lab.pjbdd.util.PrimeUtils;

public class IntNotCache {
    protected final NotCacheData[] table;

    public IntNotCache(int size) {
        size = PrimeUtils.getGreaterNextPrime(size);
        this.table = new NotCacheData[size];
    }

    public NotCacheData get(int hash) {
        int index = Math.abs(hash % this.table.length);
        return this.table[index];
    }

    public NotCacheData put(int input, int res) {
        int index = Math.abs(input % this.table.length);
        NotCacheData old = this.get(index);
        this.table[index] = new NotCacheData(input, res);
        return old;
    }

    public void clear() {
        IntStream.range(0, this.table.length).forEach(i -> {
            this.table[i] = null;
        });
    }

    public int size() {
        return this.table.length;
    }

    public int nodeCount() {
        return (int)Arrays.stream(this.table).filter(Objects::nonNull).count();
    }
}

