/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.pjbdd.intBDD.cache;

import java.util.Arrays;
import java.util.Objects;
import java.util.stream.IntStream;
import org.sosy_lab.pjbdd.intBDD.cache.OpCacheData;
import org.sosy_lab.pjbdd.util.PrimeUtils;

public class IntOpCache {
    protected final OpCacheData[] table;

    public IntOpCache(int size) {
        size = PrimeUtils.getGreaterNextPrime(size);
        this.table = new OpCacheData[size];
    }

    public OpCacheData get(int hash) {
        int index = Math.abs(hash % this.table.length);
        return this.table[index];
    }

    public OpCacheData put(int hash, OpCacheData data) {
        int index = Math.abs(hash % this.table.length);
        OpCacheData old = this.get(hash);
        this.table[index] = data;
        return old;
    }

    public void clear() {
        IntStream.range(0, this.table.length).forEach(i -> {
            this.table[i] = null;
        });
    }

    public OpCacheData createEntry(int f1, int f2, int op, int res) {
        return new OpCacheData(f1, f2, op, res);
    }

    public int size() {
        return this.table.length;
    }

    public int nodeCount() {
        return (int)Arrays.stream(this.table).filter(Objects::nonNull).count();
    }
}

