/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.pjbdd.intBDD.cache;

import java.util.Arrays;
import java.util.Objects;
import java.util.stream.IntStream;
import org.sosy_lab.pjbdd.intBDD.cache.QuantCacheData;
import org.sosy_lab.pjbdd.util.PrimeUtils;

public class IntQuantCache {
    protected final QuantCacheData[] table;

    public IntQuantCache(int size) {
        size = PrimeUtils.getGreaterNextPrime(size);
        this.table = new QuantCacheData[size];
    }

    public QuantCacheData get(int hash) {
        int index = Math.abs(hash % this.table.length);
        return this.table[index];
    }

    public QuantCacheData put(int hash, QuantCacheData data) {
        int index = Math.abs(hash % this.table.length);
        QuantCacheData old = this.table[index];
        this.table[index] = data;
        return old;
    }

    public void clear() {
        IntStream.range(0, this.table.length).forEach(i -> {
            this.table[i] = null;
        });
    }

    public QuantCacheData createEntry(int f1, int[] f2, int res) {
        return new QuantCacheData(f1, f2, res);
    }

    public int size() {
        return this.table.length;
    }

    public int nodeCount() {
        return (int)Arrays.stream(this.table).filter(Objects::nonNull).count();
    }
}

