/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.pjbdd.test;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import org.junit.Assert;
import org.junit.Assume;
import org.sosy_lab.pjbdd.api.Creator;
import org.sosy_lab.pjbdd.api.Statistics;
import org.sosy_lab.pjbdd.examples.NQueens;
import org.sosy_lab.pjbdd.test.CreatorCombinatorTest;

public class CleanUnusedNodesTest
extends CreatorCombinatorTest {
    @Override
    public void test() {
        this.triggerGarbageCollectionAndTriggerCleanDecrementsNodeCount();
        this.triggerCleanDoesNotIncreaseTableSize();
        this.creator.shutDown();
    }

    @SuppressFBWarnings(value={"DM_GC"}, justification="This test case checks unique table cleaning after garbage collection. Immediate GC is required for this test.")
    private void triggerGarbageCollectionAndTriggerCleanDecrementsNodeCount() {
        NQueens test = new NQueens(5, this.creator);
        test.build();
        Creator.Stats statsBeforeClean = Statistics.of(this.creator);
        test = null;
        System.gc();
        try {
            Thread.sleep(50L);
        }
        catch (InterruptedException e) {
            Assume.assumeNoException((Throwable)e);
        }
        this.creator.cleanUnusedNodes();
        Creator.Stats statsAfterClean = Statistics.of(this.creator);
        Assert.assertTrue((statsAfterClean.getNodeCount() < statsBeforeClean.getNodeCount() ? 1 : 0) != 0);
    }

    private void triggerCleanDoesNotIncreaseTableSize() {
        NQueens test = new NQueens(5, this.creator);
        test.build();
        Creator.Stats statsBeforeClean = Statistics.of(this.creator);
        this.creator.cleanUnusedNodes();
        Creator.Stats statsAfterClean = Statistics.of(this.creator);
        Assert.assertEquals((long)statsBeforeClean.getUniqueTableSize(), (long)statsAfterClean.getUniqueTableSize());
    }
}

