/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.pjbdd.test;

import java.util.ArrayList;
import java.util.Collection;
import org.junit.After;
import org.junit.Assume;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;
import org.sosy_lab.pjbdd.api.Builders;
import org.sosy_lab.pjbdd.api.Creator;
import org.sosy_lab.pjbdd.api.CreatorBuilder;

@RunWith(value=Parameterized.class)
public class CreatorCombinatorTest {
    @Parameterized.Parameter(value=2)
    public CreatorType ct;
    @Parameterized.Parameter(value=0)
    public Creator creator;
    @Parameterized.Parameter(value=1)
    public UniqueTableType uniqueTableType;

    @Parameterized.Parameters(name="creator= {0}, ct={2}, table={1}")
    public static Collection<Object[]> data() {
        ArrayList<Object[]> creators = new ArrayList<Object[]>();
        for (CreatorType ct : CreatorType.values()) {
            if (ct == CreatorType.ConcurrentInt || ct == CreatorType.SerialInt) {
                if (ct == CreatorType.ConcurrentInt) {
                    creators.add(new Object[]{CreatorCombinatorTest.resolveCreator(ct, UniqueTableType.Array, false), UniqueTableType.Array, ct});
                }
                creators.add(new Object[]{CreatorCombinatorTest.resolveCreator(ct, UniqueTableType.CASArray, false), UniqueTableType.CASArray, ct});
                continue;
            }
            for (UniqueTableType ut : UniqueTableType.values()) {
                if (ut == UniqueTableType.Array && ct != CreatorType.SerialApply && ct != CreatorType.CBDD) continue;
                creators.add(new Object[]{CreatorCombinatorTest.resolveCreator(ct, ut, false), ut, ct});
            }
        }
        creators.add(new Object[]{CreatorCombinatorTest.resolveCreator(CreatorType.ConcurrentCBDD, UniqueTableType.CASArray, true), UniqueTableType.CASArray, CreatorType.ConcurrentCBDD});
        creators.add(new Object[]{CreatorCombinatorTest.resolveCreator(CreatorType.ConcurrentInt, UniqueTableType.CASArray, true), UniqueTableType.CASArray, CreatorType.ConcurrentInt});
        creators.add(new Object[]{CreatorCombinatorTest.resolveCreator(CreatorType.ForkJoin, UniqueTableType.CASArray, true), UniqueTableType.CASArray, CreatorType.ForkJoin});
        return creators;
    }

    protected void skipIfChained() {
        Assume.assumeTrue((this.ct != CreatorType.CBDD && this.ct != CreatorType.ConcurrentCBDD ? 1 : 0) != 0);
    }

    @Test
    public void test() {
    }

    @After
    public void cleanUp() {
        if (this.creator != null) {
            this.creator.shutDown();
        }
        this.creator = null;
    }

    private static Creator resolveCreator(CreatorType ct, UniqueTableType ut, boolean synchronizeReordering) {
        Creator creator;
        if (ct == CreatorType.ConcurrentInt) {
            creator = Builders.intBuilder().setThreads(4).build();
        } else if (ct == CreatorType.SerialInt) {
            creator = Builders.intBuilder().setThreads(1).build();
        } else {
            CreatorBuilder creatorBuilder = ct == CreatorType.CBDD || ct == CreatorType.ConcurrentCBDD ? Builders.cbddBuilder() : Builders.bddBuilder();
            switch (ut) {
                case HashSet: {
                    creatorBuilder.setTableType(Builders.TableType.ConcurrentHashMap);
                    break;
                }
                case HashBucket: {
                    creatorBuilder.setTableType(Builders.TableType.ConcurrentHashBucket);
                    break;
                }
                case CASArray: {
                    creatorBuilder.setTableType(Builders.TableType.CASArray);
                    break;
                }
                case Array: {
                    creatorBuilder.disableThreadSafety();
                    break;
                }
                default: {
                    throw new IllegalArgumentException("Unknown Uniquetable type");
                }
            }
            switch (ct) {
                case ForkJoin: {
                    creatorBuilder.setUseApply(false).setParallelizationType(Builders.ParallelizationType.FORK_JOIN);
                    break;
                }
                case ApplyOp: {
                    creatorBuilder.setUseApply(true).setParallelizationType(Builders.ParallelizationType.FORK_JOIN);
                    break;
                }
                case SerialApply: {
                    creatorBuilder.setUseApply(true).setParallelizationType(Builders.ParallelizationType.NONE);
                    break;
                }
                case CompletableApply: {
                    creatorBuilder.setUseApply(true).setParallelizationType(Builders.ParallelizationType.COMPLETABLE_FUTURE);
                    break;
                }
                case CompletableFuture: {
                    creatorBuilder.setUseApply(false).setParallelizationType(Builders.ParallelizationType.COMPLETABLE_FUTURE);
                    break;
                }
                case Future: {
                    creatorBuilder.setUseApply(false).setParallelizationType(Builders.ParallelizationType.FUTURE);
                    break;
                }
                case Stream: {
                    creatorBuilder.setUseApply(false).setParallelizationType(Builders.ParallelizationType.STREAM);
                    break;
                }
                case Serial: {
                    creatorBuilder.setUseApply(false).setParallelizationType(Builders.ParallelizationType.NONE);
                    break;
                }
                case Guava: {
                    creatorBuilder.setUseApply(false).setParallelizationType(Builders.ParallelizationType.GUAVA_FUTURE);
                    break;
                }
                case CBDD: {
                    creatorBuilder.setParallelizationType(Builders.ParallelizationType.NONE);
                    break;
                }
                case ConcurrentCBDD: {
                    creatorBuilder.setParallelizationType(Builders.ParallelizationType.FORK_JOIN);
                    break;
                }
                default: {
                    throw new IllegalArgumentException("Unknown Creator type");
                }
            }
            if (synchronizeReordering) {
                creatorBuilder.synchronizeReorderingOperations();
            }
            creator = creatorBuilder.build();
        }
        return creator;
    }

    public static enum UniqueTableType {
        HashBucket,
        HashSet,
        CASArray,
        Array;

    }

    protected static enum CreatorType {
        Future,
        Guava,
        Serial,
        Stream,
        CompletableFuture,
        ForkJoin,
        ApplyOp,
        SerialApply,
        CompletableApply,
        ConcurrentInt,
        SerialInt,
        CBDD,
        ConcurrentCBDD;

    }
}

