/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.pjbdd.test;

import org.junit.Assert;
import org.junit.Test;
import org.sosy_lab.pjbdd.api.Builders;
import org.sosy_lab.pjbdd.api.Creator;
import org.sosy_lab.pjbdd.examples.NQueens;
import org.sosy_lab.pjbdd.util.parser.BDDStringExporter;
import org.sosy_lab.pjbdd.util.parser.BDDStringImporter;
import org.sosy_lab.pjbdd.util.parser.DotExporter;
import org.sosy_lab.pjbdd.util.parser.DotImporter;

public class ImportExportTest {
    @Test
    public void testDotExport() {
        Creator c = Builders.bddBuilder().setCacheSize(1000).setIncreaseFactor(1).setTableSize(10000).setVarCount(100).setParallelism(1000).build();
        NQueens queens = new NQueens(4, c);
        queens.build();
        queens.solve();
        DotExporter exporter = new DotExporter();
        String stringBDD = exporter.bddToString(queens.solution());
        DotImporter importer = new DotImporter(c);
        Object bdd = importer.bddFromString(stringBDD);
        Assert.assertEquals(bdd, (Object)queens.solution());
    }

    @Test
    public void testStringExport() {
        Creator c = Builders.bddBuilder().setCacheSize(1000).setIncreaseFactor(1).setTableSize(10000).setVarCount(100).setParallelism(1000).build();
        NQueens queens = new NQueens(4, c);
        queens.build();
        queens.solve();
        BDDStringExporter exporter = new BDDStringExporter(c);
        String stringBDD = exporter.bddToString(queens.solution());
        BDDStringImporter importer = new BDDStringImporter(c);
        Object bdd = importer.bddFromString(stringBDD);
        Assert.assertEquals(bdd, (Object)queens.solution());
    }
}

