/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.pjbdd.test;

import org.junit.Assert;
import org.sosy_lab.pjbdd.api.DD;
import org.sosy_lab.pjbdd.test.CreatorCombinatorTest;

public class MakeVarBeforeTest
extends CreatorCombinatorTest {
    @Override
    public void test() {
        this.checkVarIsInsertedCorrectly();
        this.checkRemainingOrderLeftUnchanged();
        this.checkCreatedDDsWithNewVarAreOnTop();
        this.checkCallMakeVarBeforeMultipleTimes();
        this.creator.shutDown();
    }

    private void checkCreatedDDsWithNewVarAreOnTop() {
        this.skipIfChained();
        DD var10 = this.creator.makeIthVar(10);
        DD varBefore10 = this.creator.makeVariableBefore(var10);
        DD and = this.creator.makeAnd(var10, varBefore10);
        Assert.assertEquals((long)varBefore10.getVariable(), (long)and.getVariable());
        DD var5 = this.creator.makeIthVar(5);
        DD varBefore5 = this.creator.makeVariableBefore(var5);
        DD or = this.creator.makeAnd(var5, varBefore5);
        Assert.assertEquals((long)varBefore5.getVariable(), (long)or.getVariable());
    }

    private void checkRemainingOrderLeftUnchanged() {
        int[] oldOrdering = this.creator.getVariableOrdering();
        DD var10 = this.creator.makeIthVar(10);
        DD varBefore10 = this.creator.makeVariableBefore(var10);
        int[] newOrdering = this.creator.getVariableOrdering();
        int iNew = 0;
        for (int iOld = 0; iOld < oldOrdering.length; ++iOld) {
            if (newOrdering[iNew] == varBefore10.getVariable()) {
                ++iNew;
            }
            Assert.assertEquals((long)oldOrdering[iOld], (long)newOrdering[iNew]);
            ++iNew;
        }
        int[] oldOrdering2 = this.creator.getVariableOrdering();
        DD var0 = this.creator.makeIthVar(0);
        DD varBefore0 = this.creator.makeVariableBefore(var0);
        int[] newOrdering2 = this.creator.getVariableOrdering();
        int iNew2 = 0;
        for (int iOld2 = 0; iOld2 < oldOrdering2.length; ++iOld2) {
            if (newOrdering2[iNew2] == varBefore0.getVariable()) {
                ++iNew2;
            }
            Assert.assertEquals((long)oldOrdering2[iOld2], (long)newOrdering2[iNew2]);
            ++iNew2;
        }
    }

    private void checkVarIsInsertedCorrectly() {
        DD var10 = this.creator.makeIthVar(10);
        DD varBefore10 = this.creator.makeVariableBefore(var10);
        int[] ordering = this.creator.getVariableOrdering();
        boolean insertedCorrectVar10 = false;
        for (int i = 0; i < ordering.length && ordering[i] != var10.getVariable(); ++i) {
            if (ordering[i] != varBefore10.getVariable()) continue;
            insertedCorrectVar10 = ordering[i + 1] == var10.getVariable();
            break;
        }
        Assert.assertTrue((boolean)insertedCorrectVar10);
        DD var5 = this.creator.makeIthVar(5);
        DD varBefore5 = this.creator.makeVariableBefore(var5);
        int[] ordering2 = this.creator.getVariableOrdering();
        boolean insertedCorrectVar5 = false;
        for (int i = 0; i < ordering2.length && ordering2[i] != var5.getVariable(); ++i) {
            if (ordering2[i] != varBefore5.getVariable()) continue;
            insertedCorrectVar5 = ordering2[i + 1] == var5.getVariable();
            break;
        }
        Assert.assertTrue((boolean)insertedCorrectVar5);
        DD var0 = this.creator.makeIthVar(0);
        DD varBefore0 = this.creator.makeVariableBefore(var0);
        int[] ordering3 = this.creator.getVariableOrdering();
        boolean insertedCorrectVar0 = false;
        for (int i = 0; i < ordering3.length && ordering3[i] != var0.getVariable(); ++i) {
            if (ordering3[i] != varBefore0.getVariable()) continue;
            insertedCorrectVar0 = ordering3[i + 1] == var0.getVariable();
            break;
        }
        Assert.assertTrue((boolean)insertedCorrectVar0);
    }

    private void checkCallMakeVarBeforeMultipleTimes() {
        int[] oldOrdering = this.creator.getVariableOrdering();
        DD var10 = this.creator.makeIthVar(10);
        DD varBefore10_1 = this.creator.makeVariableBefore(var10);
        DD varBefore10_2 = this.creator.makeVariableBefore(var10);
        DD varBefore10_3 = this.creator.makeVariableBefore(var10);
        DD varBefore10_4 = this.creator.makeVariableBefore(var10);
        int[] newOrdering = this.creator.getVariableOrdering();
        int iNew = 0;
        for (int iOld = 0; iOld < oldOrdering.length; ++iOld) {
            if (newOrdering[iNew] == varBefore10_1.getVariable()) {
                Assert.assertEquals((long)newOrdering[++iNew], (long)varBefore10_2.getVariable());
                Assert.assertEquals((long)newOrdering[++iNew], (long)varBefore10_3.getVariable());
                Assert.assertEquals((long)newOrdering[++iNew], (long)varBefore10_4.getVariable());
                Assert.assertEquals((long)newOrdering[++iNew], (long)var10.getVariable());
            }
            Assert.assertEquals((long)oldOrdering[iOld], (long)newOrdering[iNew]);
            ++iNew;
        }
    }
}

