/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.pjbdd.test;

import org.junit.Assert;
import org.sosy_lab.pjbdd.api.Creator;
import org.sosy_lab.pjbdd.api.DD;
import org.sosy_lab.pjbdd.api.Statistics;
import org.sosy_lab.pjbdd.examples.NQueens;
import org.sosy_lab.pjbdd.test.CreatorCombinatorTest;

public class SimpleStatsTest
extends CreatorCombinatorTest {
    @Override
    public void test() {
        this.skipIfChained();
        this.testSimpleCreatorStats();
        this.testSimpleBDDStats();
        this.testNQueensStats();
        this.creator.shutDown();
    }

    private void testSimpleCreatorStats() {
        DD var1 = this.creator.makeVariable();
        DD var2 = this.creator.makeVariable();
        Creator.Stats creatorStats = Statistics.of(this.creator);
        Assert.assertEquals((long)12L, (long)creatorStats.getVariableCount());
        Assert.assertEquals((long)26L, (long)creatorStats.getNodeCount());
        DD unused = this.creator.makeAnd(var1, var2);
        Creator.Stats creatorStats2 = Statistics.of(this.creator);
        Assert.assertEquals((long)27L, (long)creatorStats2.getNodeCount());
        Assert.assertEquals((long)1L, (long)creatorStats2.getCacheNodeCount());
        Assert.assertFalse((boolean)unused.isLeaf());
    }

    private void testSimpleBDDStats() {
        DD var1 = this.creator.makeVariable();
        DD var2 = this.creator.makeVariable();
        Statistics.DDStats ddStats = Statistics.of(var1);
        Assert.assertEquals((long)3L, (long)ddStats.getNodeCount());
        Assert.assertEquals((long)2L, (long)ddStats.getEdgeCount());
        DD res3 = this.creator.makeAnd(var1, this.creator.makeFalse());
        Statistics.DDStats ddStats2 = Statistics.of(res3);
        Assert.assertEquals((long)1L, (long)ddStats2.getNodeCount());
        Assert.assertEquals((long)0L, (long)ddStats2.getEdgeCount());
        DD res = this.creator.makeAnd(var1, var2);
        Statistics.DDStats ddStats3 = Statistics.of(res);
        Assert.assertEquals((long)4L, (long)ddStats3.getNodeCount());
        Assert.assertEquals((long)4L, (long)ddStats3.getEdgeCount());
    }

    private void testNQueensStats() {
        NQueens nQueens = new NQueens(4, this.creator);
        nQueens.build();
        Statistics.DDStats ddStats1 = Statistics.of(nQueens.solution());
        Assert.assertEquals((long)31L, (long)ddStats1.getNodeCount());
        Assert.assertEquals((long)58L, (long)ddStats1.getEdgeCount());
    }
}

