/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.pjbdd.test;

import java.util.ArrayList;
import java.util.Collection;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;
import org.sosy_lab.pjbdd.api.Builders;
import org.sosy_lab.pjbdd.api.ZDDBuilder;
import org.sosy_lab.pjbdd.api.ZDDCreator;

@RunWith(value=Parameterized.class)
public class ZDDCombinatorTest {
    @Parameterized.Parameter(value=0)
    public ZDDCreator creator;
    @Parameterized.Parameter(value=1)
    public UniqueTableType uniqueTableType;

    @Parameterized.Parameters(name="creator={0}, table={1}")
    public static Collection<Object[]> data() {
        ArrayList<Object[]> creators = new ArrayList<Object[]>();
        for (CreatorType ct : CreatorType.values()) {
            for (UniqueTableType ut : UniqueTableType.values()) {
                creators.add(new Object[]{ZDDCombinatorTest.resolveCreator(ut, ct), ut});
            }
        }
        return creators;
    }

    @Test
    public void test() {
    }

    private static ZDDCreator resolveCreator(UniqueTableType ut, CreatorType ct) {
        ZDDBuilder creatorBuilder = Builders.zddBuilder().setVarCount(0);
        switch (ut) {
            case HashSet: {
                creatorBuilder.setTableType(Builders.TableType.ConcurrentHashMap);
                break;
            }
            case HashBucket: {
                creatorBuilder.setTableType(Builders.TableType.ConcurrentHashBucket);
                break;
            }
            case ResizingArray: {
                creatorBuilder.setTableType(Builders.TableType.CASArray);
                break;
            }
            default: {
                throw new IllegalArgumentException("Unknown Uniquetable type: " + ut);
            }
        }
        switch (ct) {
            case Serial: {
                return creatorBuilder.setThreads(1).build();
            }
            case Concurrent: {
                return creatorBuilder.setThreads(4).build();
            }
        }
        return creatorBuilder.setThreads(1).build();
    }

    static enum CreatorType {
        Serial,
        Concurrent;

    }

    static enum UniqueTableType {
        HashBucket,
        HashSet,
        ResizingArray;

    }
}

