/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.pjbdd.util;

import java.math.BigInteger;

public class PrimeUtils {
    private PrimeUtils() {
    }

    private static boolean isEven(int i) {
        return (i & 1) == 0;
    }

    public static int getGreaterNextPrime(int src) {
        BigInteger bigInteger;
        if (PrimeUtils.isEven(src)) {
            ++src;
        }
        if ((bigInteger = BigInteger.valueOf(src)).isProbablePrime(20)) {
            return src;
        }
        return bigInteger.nextProbablePrime().intValue();
    }

    public static int getLowerNextPrime(int src) {
        if (PrimeUtils.isEven(src)) {
            --src;
        }
        if (BigInteger.valueOf(src).isProbablePrime(20)) {
            return src;
        }
        return PrimeUtils.getLowerNextPrime(src - 2);
    }
}

