/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.pjbdd.util.parser;

import java.util.HashMap;
import java.util.Map;
import org.sosy_lab.pjbdd.api.Creator;
import org.sosy_lab.pjbdd.api.DD;
import org.sosy_lab.pjbdd.util.parser.Exporter;

public class BDDStringExporter
implements Exporter<DD> {
    private final Creator creator;

    public BDDStringExporter(Creator creator) {
        this.creator = creator;
    }

    private StringBuilder toBDDString(DD bdd, Map<DD, Integer> cash, StringBuilder buffer) {
        if (!cash.containsKey(this.creator.getLow(bdd))) {
            this.toBDDString(this.creator.getLow(bdd), cash, buffer);
        }
        if (!cash.containsKey(this.creator.getHigh(bdd))) {
            this.toBDDString(this.creator.getHigh(bdd), cash, buffer);
        }
        cash.putIfAbsent(bdd, cash.size());
        return buffer.append(cash.get(bdd)).append(";").append(bdd.getVariable()).append(";").append(cash.get(this.creator.getLow(bdd))).append(";").append(cash.get(this.creator.getHigh(bdd))).append("\n");
    }

    @Override
    public String extension() {
        return ".txt";
    }

    @Override
    public String bddToString(DD node) {
        HashMap<DD, Integer> cash = new HashMap<DD, Integer>();
        cash.put(this.creator.makeFalse(), 0);
        cash.put(this.creator.makeTrue(), 1);
        StringBuilder buffer = new StringBuilder(node.getVariable() * 4 * 3);
        this.toBDDString(node, cash, buffer.append("0\n").append("1\n"));
        StringBuilder result = this.makeHeaderLine(node, cash.size() - 1);
        return result.append((CharSequence)buffer).toString();
    }

    private StringBuilder makeHeaderLine(DD node, int index) {
        int[] varOrdering;
        StringBuilder builder = new StringBuilder(node.getVariable() * 3);
        builder.append(index).append(";").append(this.creator.getVariableCount()).append(";");
        for (int i : varOrdering = this.creator.getVariableOrdering()) {
            builder.append(i).append(",");
        }
        return builder.append("\n");
    }
}

