/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.pjbdd.util.parser;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.StringTokenizer;
import java.util.stream.Stream;
import org.sosy_lab.pjbdd.api.Creator;
import org.sosy_lab.pjbdd.api.DD;
import org.sosy_lab.pjbdd.util.parser.ImportExportException;
import org.sosy_lab.pjbdd.util.parser.Importer;

public class BDDStringImporter
implements Importer<DD> {
    private final Map<Integer, DD> cash;
    private final Creator nodeFactory;

    public BDDStringImporter(Creator nodeFactory) {
        this.nodeFactory = nodeFactory;
        this.cash = new HashMap<Integer, DD>();
    }

    @Override
    public DD importFromLinesStream(Stream<String> lines) {
        Iterator nodeIterator = lines.iterator();
        int root = this.importHeader((String)nodeIterator.next());
        while (nodeIterator.hasNext()) {
            this.initBDDFromLine((String)nodeIterator.next());
        }
        lines.close();
        DD bdd = this.cash.get(root);
        this.cash.clear();
        return bdd;
    }

    private int importHeader(String line) {
        if (line.isEmpty()) {
            throw new ImportExportException(ImportExportException.ErrorCodes.InvalidFileFormat);
        }
        StringTokenizer tokenizer = new StringTokenizer(line, ";");
        try {
            int root = Integer.parseInt(tokenizer.nextToken());
            int count = Integer.parseInt(tokenizer.nextToken());
            this.nodeFactory.setVariableCount(count);
            StringTokenizer varOrderTokenizer = new StringTokenizer(tokenizer.nextToken(), ",");
            ArrayList<Integer> varOrder = new ArrayList<Integer>();
            while (varOrderTokenizer.hasMoreElements()) {
                varOrder.add(Integer.parseInt(varOrderTokenizer.nextToken()));
            }
            this.nodeFactory.setVarOrder(varOrder);
            return root;
        }
        catch (NumberFormatException | NoSuchElementException e) {
            throw new ImportExportException(ImportExportException.ErrorCodes.InvalidFileFormat);
        }
    }

    private void initBDDFromLine(String line) {
        StringTokenizer tokenizer = new StringTokenizer(line, ";");
        try {
            int index = Integer.parseInt(tokenizer.nextToken());
            if (index == 0) {
                this.cash.put(index, this.nodeFactory.makeFalse());
            } else if (index == 1) {
                this.cash.put(index, this.nodeFactory.makeTrue());
            } else {
                int var = Integer.parseInt(tokenizer.nextToken());
                int low = Integer.parseInt(tokenizer.nextToken());
                int high = Integer.parseInt(tokenizer.nextToken());
                assert (this.cash.containsKey(low));
                assert (this.cash.containsKey(high));
                this.cash.put(index, this.nodeFactory.makeNode(this.cash.get(low), this.cash.get(high), var));
            }
        }
        catch (NumberFormatException | NoSuchElementException e) {
            throw new ImportExportException(ImportExportException.ErrorCodes.InvalidFileFormat);
        }
    }
}

