/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.pjbdd.util.parser;

import java.util.HashMap;
import java.util.Map;
import org.sosy_lab.pjbdd.api.DD;
import org.sosy_lab.pjbdd.cbdd.CDD;
import org.sosy_lab.pjbdd.util.parser.Exporter;

public class DotExporter
implements Exporter<DD> {
    private final Map<DD, Integer> bddEnumeration = new HashMap<DD, Integer>();

    @Override
    public String extension() {
        return ".dot";
    }

    @Override
    public String bddToString(DD node) {
        Object result = "digraph G {\n";
        result = (String)result + this.recursiveBddToDotStrings(node).toString();
        result = (String)result + "}";
        this.bddEnumeration.clear();
        return result;
    }

    private StringBuilder recursiveBddToDotStrings(DD node) {
        StringBuilder result = new StringBuilder();
        this.bddEnumeration.putIfAbsent(node, this.bddEnumeration.size());
        if (!node.isLeaf()) {
            if (!this.bddEnumeration.containsKey(node.getLow())) {
                result.append((CharSequence)this.recursiveBddToDotStrings(node.getLow()));
            }
            if (!this.bddEnumeration.containsKey(node.getHigh())) {
                result.append((CharSequence)this.recursiveBddToDotStrings(node.getHigh()));
            }
        }
        return result.append(this.nodeToString(node)).append("\n");
    }

    private String nodeToString(DD node) {
        CDD cbddNode;
        if (node.isFalse()) {
            int index = this.bddEnumeration.get(node);
            return index + "[label=0]";
        }
        if (node.isTrue()) {
            int index = this.bddEnumeration.get(node);
            return index + "[label=1]";
        }
        int index = this.bddEnumeration.get(node);
        String label = "x" + node.getVariable();
        if (node instanceof CDD && (cbddNode = (CDD)node).getVariable() != cbddNode.getChainEndVariable()) {
            label = label + "x" + cbddNode.getChainEndVariable();
        }
        return index + "[label=" + label + "] \n" + index + "->" + this.bddEnumeration.get(node.getLow()) + "[style=dashed]  \n" + index + "->" + this.bddEnumeration.get(node.getHigh());
    }
}

