/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.pjbdd.util.parser;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.StringTokenizer;
import java.util.stream.Stream;
import org.sosy_lab.pjbdd.api.Creator;
import org.sosy_lab.pjbdd.api.DD;
import org.sosy_lab.pjbdd.util.parser.ImportExportException;
import org.sosy_lab.pjbdd.util.parser.Importer;

public class DotImporter
implements Importer<DD> {
    private final Map<Integer, DD> cash;
    private final Map<Integer, Integer> highCash;
    private final Map<Integer, Integer> lowCash;
    private final Map<Integer, Integer> varCash;
    private final List<Integer> variableOrder;
    private final Creator nodeFactory;

    public DotImporter(Creator nodeFactory) {
        this.nodeFactory = nodeFactory;
        this.cash = new HashMap<Integer, DD>();
        this.highCash = new HashMap<Integer, Integer>();
        this.lowCash = new HashMap<Integer, Integer>();
        this.varCash = new LinkedHashMap<Integer, Integer>();
        this.variableOrder = new ArrayList<Integer>();
    }

    @Override
    public DD importFromLinesStream(Stream<String> lines) {
        lines.forEach(this::initBDDFromLine);
        return this.buildBDD();
    }

    private DD buildBDD() {
        DD result = this.nodeFactory.makeFalse();
        for (Integer index : this.variableOrder) {
            int var = this.varCash.get(index);
            if (var < 0) {
                result = var == -1 ? this.nodeFactory.makeTrue() : this.nodeFactory.makeFalse();
                this.cash.put(index, result);
                continue;
            }
            int low = this.lowCash.get(index);
            int high = this.highCash.get(index);
            DD lowBDD = this.cash.get(low);
            DD highBDD = this.cash.get(high);
            result = this.nodeFactory.makeNode(lowBDD, highBDD, var);
            this.cash.put(index, result);
        }
        this.clean();
        return result;
    }

    private void clean() {
        this.cash.clear();
        this.highCash.clear();
        this.lowCash.clear();
        this.varCash.clear();
        this.variableOrder.clear();
    }

    private void initBDDFromLine(String line) {
        StringTokenizer tokenizer = new StringTokenizer(line.trim(), ";\n");
        try {
            while (tokenizer.hasMoreTokens()) {
                String next = tokenizer.nextToken();
                if (next.contains("->")) {
                    this.importEdge(next);
                    continue;
                }
                if (next.matches("(\\d+\\[label=x\\d+.*)")) {
                    this.importNode(next);
                    continue;
                }
                if (!next.matches("(\\d+\\[label=\\d+.*)")) continue;
                this.importTrueOrFalse(next);
            }
        }
        catch (NumberFormatException | NoSuchElementException e) {
            throw new ImportExportException(ImportExportException.ErrorCodes.InvalidFileFormat);
        }
    }

    private void importTrueOrFalse(String next) {
        StringTokenizer tokenizer = new StringTokenizer(next.replaceAll("\\[label", "").replaceAll("\\]", ""), "=");
        int node = Integer.parseInt(tokenizer.nextToken());
        int leaf = Integer.parseInt(tokenizer.nextToken());
        int var = leaf == 0 ? -2 : -1;
        this.varCash.put(node, var);
    }

    private void importNode(String next) {
        StringTokenizer tokenizer = new StringTokenizer(next.replaceAll("\\[label=", "").replaceAll("\\]", ""), "x");
        int node = Integer.parseInt(tokenizer.nextToken());
        int var = Integer.parseInt(tokenizer.nextToken());
        this.varCash.put(node, var);
    }

    private void importEdge(String next) {
        StringTokenizer tokenizer = new StringTokenizer(next, "->");
        int parent = Integer.parseInt(tokenizer.nextToken());
        int child = Integer.parseInt(tokenizer.nextToken().replaceAll("\\[style=dashed\\]", ""));
        this.checkOrder(parent, child);
        if (next.contains("[style=dashed]")) {
            this.lowCash.put(parent, child);
        } else {
            this.highCash.put(parent, child);
        }
    }

    private void checkOrder(int parent, int child) {
        if (this.variableOrder.contains(parent) && this.variableOrder.contains(child)) {
            int indexParent = this.variableOrder.indexOf(parent);
            int indexChild = this.variableOrder.indexOf(child);
            if (indexChild > indexParent) {
                this.variableOrder.remove(indexChild);
                this.variableOrder.add(indexParent, child);
            }
        } else if (this.variableOrder.contains(parent) && !this.variableOrder.contains(child)) {
            this.variableOrder.add(this.variableOrder.indexOf(parent), child);
        } else {
            if (!this.variableOrder.contains(child)) {
                this.variableOrder.add(child);
            }
            if (!this.variableOrder.contains(parent)) {
                this.variableOrder.add(parent);
            }
        }
    }
}

