/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.pjbdd.util.parser;

import java.io.File;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.time.Instant;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.util.Date;
import org.sosy_lab.pjbdd.api.DD;
import org.sosy_lab.pjbdd.util.parser.ImportExportException;

public interface Exporter<V extends DD> {
    public static final String DEFAULT_PATH = "./res/";

    public String bddToString(V var1);

    public String extension();

    default public File export(V graph, String path, String name) {
        Path file = Paths.get(path + name + this.extension(), new String[0]);
        this.write(file, this.bddToString(graph));
        return file.toFile();
    }

    default public File export(V graph, String path) {
        return this.export(graph, path, this.generateFromTimeStamp());
    }

    default public File export(V bdd) {
        return this.export(bdd, DEFAULT_PATH);
    }

    default public String generateFromTimeStamp() {
        Instant instant = Instant.ofEpochMilli(new Date().getTime());
        Object s = LocalDateTime.ofInstant(instant, ZoneId.systemDefault()).toLocalDate().toString();
        s = (String)s + "/" + LocalDateTime.ofInstant(instant, ZoneId.systemDefault()).toLocalTime();
        return s;
    }

    default public void write(Path file, String stringBDD) {
        try {
            Files.createDirectories(file.getParent(), new FileAttribute[0]);
            Files.write(file, stringBDD.getBytes(StandardCharsets.UTF_8), new OpenOption[0]);
        }
        catch (IOException e) {
            throw new ImportExportException(ImportExportException.ErrorCodes.FileOpen);
        }
    }
}

