/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.pjbdd.util.parser;

import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.stream.Stream;
import org.sosy_lab.pjbdd.api.DD;
import org.sosy_lab.pjbdd.util.parser.ImportExportException;

public interface Importer<V extends DD> {
    public V importFromLinesStream(Stream<String> var1);

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    default public V importBDDFromFile(Path file) {
        try (Stream<String> lines = Files.lines(file, StandardCharsets.UTF_8);){
            V v = this.importFromLinesStream(lines);
            return v;
        }
        catch (IOException e) {
            throw new ImportExportException(ImportExportException.ErrorCodes.FileOpen);
        }
    }

    default public V importBDDFromPath(String path) {
        return this.importBDDFromFile(Paths.get(path, new String[0]));
    }

    default public V bddFromString(String node) {
        return this.importFromLinesStream(Stream.of(node.split("\n")));
    }
}

