/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.pjbdd.util.threadpool;

import java.util.concurrent.ForkJoinPool;
import java.util.concurrent.atomic.AtomicInteger;
import org.sosy_lab.pjbdd.util.threadpool.ParallelismManager;

public class ParallelismManagerImpl
implements ParallelismManager {
    private final ForkJoinPool threadPool;
    private final AtomicInteger submissionCount = new AtomicInteger();
    private final int parallelism;

    public ParallelismManagerImpl() {
        this(Runtime.getRuntime().availableProcessors());
    }

    public ParallelismManagerImpl(int parallelism) {
        this.parallelism = parallelism;
        this.threadPool = new ForkJoinPool(parallelism);
    }

    @Override
    public ForkJoinPool getThreadPool() {
        return this.threadPool;
    }

    @Override
    public int getParallelism() {
        return this.parallelism;
    }

    @Override
    public boolean canFork(int topLevel) {
        return this.submissionCount.get() <= this.getParallelism();
    }

    @Override
    public void taskSupplied() {
        this.submissionCount.incrementAndGet();
    }

    @Override
    public void taskDone() {
        this.submissionCount.decrementAndGet();
    }

    @Override
    public void shutdown() {
        this.threadPool.shutdown();
    }
}

