/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.pjbdd.zdd;

import java.math.BigInteger;
import java.util.List;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.sosy_lab.pjbdd.api.AbstractCreator;
import org.sosy_lab.pjbdd.api.DD;
import org.sosy_lab.pjbdd.api.ZDDCreator;
import org.sosy_lab.pjbdd.core.algorithm.SatAlgorithm;
import org.sosy_lab.pjbdd.core.node.NodeManager;
import org.sosy_lab.pjbdd.zdd.ZDDAlgorithm;

public class ZDDCreatorImpl
extends AbstractCreator
implements ZDDCreator {
    private final ZDDAlgorithm<DD> algorithm;
    private final ReadWriteLock reorderLock = new ReentrantReadWriteLock();

    public ZDDCreatorImpl(SatAlgorithm<DD> satAlgorithm, NodeManager<DD> nodeManager, ZDDAlgorithm<DD> algorithm) {
        super(nodeManager, satAlgorithm);
        this.algorithm = algorithm;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DD subSet1(DD zdd, DD var) {
        this.reorderLock.readLock().lock();
        try {
            DD dD = this.algorithm.subSet1(zdd, var);
            return dD;
        }
        finally {
            this.reorderLock.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DD subSet0(DD zdd, DD var) {
        this.reorderLock.readLock().lock();
        try {
            DD dD = this.algorithm.subSet0(zdd, var);
            return dD;
        }
        finally {
            this.reorderLock.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DD change(DD zdd, DD var) {
        this.reorderLock.readLock().lock();
        try {
            DD dD = this.algorithm.change(zdd, var);
            return dD;
        }
        finally {
            this.reorderLock.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DD union(DD zdd1, DD zdd2) {
        this.reorderLock.readLock().lock();
        try {
            DD dD = this.algorithm.union(zdd1, zdd2);
            return dD;
        }
        finally {
            this.reorderLock.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DD difference(DD zdd1, DD zdd2) {
        this.reorderLock.readLock().lock();
        try {
            DD dD = this.algorithm.difference(zdd1, zdd2);
            return dD;
        }
        finally {
            this.reorderLock.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DD intersection(DD zdd1, DD zdd2) {
        this.reorderLock.readLock().lock();
        try {
            DD dD = this.algorithm.intersection(zdd1, zdd2);
            return dD;
        }
        finally {
            this.reorderLock.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DD product(DD zdd1, DD zdd2) {
        this.reorderLock.readLock().lock();
        try {
            DD dD = this.algorithm.product(zdd1, zdd2);
            return dD;
        }
        finally {
            this.reorderLock.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DD modulo(DD zdd1, DD zdd2) {
        this.reorderLock.readLock().lock();
        try {
            DD dD = this.algorithm.modulo(zdd1, zdd2);
            return dD;
        }
        finally {
            this.reorderLock.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DD division(DD zdd1, DD zdd2) {
        this.reorderLock.readLock().lock();
        try {
            DD dD = this.algorithm.division(zdd1, zdd2);
            return dD;
        }
        finally {
            this.reorderLock.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DD exclude(DD zdd1, DD zdd2) {
        this.reorderLock.readLock().lock();
        try {
            DD dD = this.algorithm.exclude(zdd1, zdd2);
            return dD;
        }
        finally {
            this.reorderLock.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DD restrict(DD zdd1, DD zdd2) {
        this.reorderLock.readLock().lock();
        try {
            DD dD = this.algorithm.restrict(zdd1, zdd2);
            return dD;
        }
        finally {
            this.reorderLock.readLock().unlock();
        }
    }

    @Override
    public DD makeNode(DD low, DD high, int var) {
        return this.algorithm.makeNode(low, high, var);
    }

    @Override
    public DD empty() {
        return this.nodeManager.getFalse();
    }

    @Override
    public DD base() {
        return this.nodeManager.getTrue();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DD universe() {
        this.reorderLock.readLock().lock();
        try {
            DD universe = this.base();
            int[] order = this.nodeManager.getCurrentOrdering();
            int i = order.length;
            while (i > 0) {
                universe = this.makeNode(universe, universe, order[--i]);
            }
            DD dD = universe;
            return dD;
        }
        finally {
            this.reorderLock.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DD cube(int ... vars) {
        this.reorderLock.readLock().lock();
        try {
            DD cube = this.base();
            int[] order = this.getVariableOrdering();
            int i = vars.length;
            while (i > 0) {
                if (vars[--i] == 1) {
                    cube = this.makeNode(this.empty(), cube, order[i]);
                }
                if (vars[i] != -1) continue;
                cube = this.makeNode(cube, cube, order[i]);
            }
            DD dD = cube;
            return dD;
        }
        finally {
            this.reorderLock.readLock().unlock();
        }
    }

    @Override
    public BigInteger satCount(DD bdd) {
        this.reorderLock.readLock().lock();
        try {
            BigInteger bigInteger = this.satAlgorithm.satCount(bdd);
            return bigInteger;
        }
        finally {
            this.reorderLock.readLock().unlock();
        }
    }

    @Override
    public void shutdown() {
        this.algorithm.shutdown();
        this.nodeManager.shutdown();
    }

    @Override
    public void setVarOrder(List<Integer> pOrder) {
        this.reorderLock.writeLock().lock();
        try {
            this.nodeManager.setVarOrder(pOrder);
        }
        finally {
            this.reorderLock.writeLock().unlock();
        }
    }

    @Override
    public void setVariableCount(int count) {
        this.reorderLock.writeLock().lock();
        try {
            this.nodeManager.setVarCount(count);
        }
        finally {
            this.reorderLock.writeLock().unlock();
        }
    }
}

