/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.pjbdd.zdd;

import java.math.BigInteger;
import org.sosy_lab.pjbdd.api.DD;
import org.sosy_lab.pjbdd.bdd.BDDSat;
import org.sosy_lab.pjbdd.core.cache.Cache;
import org.sosy_lab.pjbdd.core.node.NodeManager;

public class ZDDSat<V extends DD>
extends BDDSat<V> {
    public ZDDSat(Cache<V, BigInteger> satCountCache, NodeManager<V> nodeManager) {
        super(satCountCache, nodeManager);
    }

    @Override
    public BigInteger satCount(V b) {
        if (b.isTrue()) {
            return BigInteger.ONE;
        }
        if (b.isFalse()) {
            return BigInteger.ZERO;
        }
        BigInteger count = (BigInteger)this.satCountCache.get(b);
        if (count != null) {
            return count;
        }
        BigInteger res = this.satCount(this.low(b)).add(this.satCount(this.high(b)));
        this.satCountCache.put(b, res);
        return res;
    }
}

