/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.pjbdd.zdd;

import java.util.Optional;
import org.sosy_lab.pjbdd.api.DD;
import org.sosy_lab.pjbdd.core.algorithm.ManipulatingAlgorithm;
import org.sosy_lab.pjbdd.core.cache.Cache;
import org.sosy_lab.pjbdd.core.node.NodeManager;
import org.sosy_lab.pjbdd.zdd.ZDDAlgorithm;

public class ZDDSerialAlgorithm<V extends DD>
extends ManipulatingAlgorithm<V>
implements ZDDAlgorithm<V> {
    public ZDDSerialAlgorithm(Cache<Integer, Cache.CacheData> computedTable, NodeManager<V> nodeManager) {
        super(computedTable, nodeManager);
    }

    @Override
    public V subSet1(V zdd, V var) {
        return this.unaryShannon(zdd, var, ZDDAlgorithm.ZddOps.SUB_SET1);
    }

    private Optional<V> subset1Check(V zdd, V var) {
        if (this.level(zdd) > this.level(var)) {
            return Optional.of(this.empty());
        }
        if (this.level(zdd) == this.level(var)) {
            return Optional.of(this.getHigh(zdd));
        }
        return this.checkBinaryCache(zdd, var, ZDDAlgorithm.ZddOps.SUB_SET1.ordinal());
    }

    @Override
    public V subSet0(V zdd, V var) {
        return this.unaryShannon(zdd, var, ZDDAlgorithm.ZddOps.SUB_SET0);
    }

    private Optional<V> subset0Check(V zdd, V var) {
        if (this.level(zdd) > this.level(var)) {
            return Optional.of(zdd);
        }
        if (this.level(zdd) == this.level(var)) {
            return Optional.of(this.getLow(zdd));
        }
        return this.checkBinaryCache(zdd, var, ZDDAlgorithm.ZddOps.SUB_SET0.ordinal());
    }

    @Override
    public V change(V zdd, V var) {
        return this.unaryShannon(zdd, var, ZDDAlgorithm.ZddOps.CHANGE);
    }

    private Optional<V> changeCheck(V zdd, V var) {
        if (this.level(zdd) > this.level(var)) {
            return Optional.of(this.makeNode(this.empty(), zdd, var.getVariable()));
        }
        if (this.level(zdd) == this.level(var)) {
            return Optional.of(this.makeNode(this.getHigh(zdd), this.getLow(zdd), var.getVariable()));
        }
        return this.checkBinaryCache(zdd, var, ZDDAlgorithm.ZddOps.CHANGE.ordinal());
    }

    protected V unaryShannon(V zdd, V var, ZDDAlgorithm.ZddOps op) {
        return (V)this.operationCheck(zdd, var, op).orElseGet(() -> {
            DD low = this.unaryShannon(this.getLow(zdd), var, op);
            DD high = this.unaryShannon(this.getHigh(zdd), var, op);
            DD res = this.makeNode(low, high, zdd.getVariable());
            this.cacheBinaryItem(zdd, var, op.ordinal(), res);
            return res;
        });
    }

    @Override
    public V union(V f1, V f2) {
        return (V)this.unionCheck(f1, f2).orElseGet(() -> {
            DD res = this.level(f1) < this.level(f2) ? this.makeNode(this.union(this.getLow(f1), f2), this.getHigh(f1), f1.getVariable()) : (this.level(f1) == this.level(f2) ? this.makeNode(this.union(this.getLow(f1), this.getLow(f2)), this.union(this.getHigh(f1), this.getHigh(f2)), f2.getVariable()) : this.makeNode(this.union(f1, this.getLow(f2)), this.getHigh(f2), f2.getVariable()));
            this.cacheBinaryItem(f1, f2, ZDDAlgorithm.ZddOps.UNION.ordinal(), res);
            return res;
        });
    }

    protected Optional<V> unionCheck(V f1, V f2) {
        if (f1.equals(this.empty())) {
            return Optional.of(f2);
        }
        if (f2.equals(this.empty())) {
            return Optional.of(f1);
        }
        if (f1.equals(f2)) {
            return Optional.of(f1);
        }
        return this.checkBinaryCache(f1, f2, ZDDAlgorithm.ZddOps.UNION.ordinal());
    }

    @Override
    public V difference(V f1, V f2) {
        return (V)this.differenceCheck(f1, f2).orElseGet(() -> {
            DD res = this.level(f1) < this.level(f2) ? this.makeNode(this.difference(this.getLow(f1), f2), this.getHigh(f1), f1.getVariable()) : (this.level(f1) == this.level(f2) ? this.makeNode(this.difference(this.getLow(f1), this.getLow(f2)), this.difference(this.getHigh(f1), this.getHigh(f2)), f2.getVariable()) : this.difference(f1, this.getLow(f2)));
            this.cacheBinaryItem(f1, f2, ZDDAlgorithm.ZddOps.DIFF.ordinal(), res);
            return res;
        });
    }

    protected Optional<V> differenceCheck(V f1, V f2) {
        if (f1.equals(this.empty())) {
            return Optional.of(this.empty());
        }
        if (f2.equals(this.empty())) {
            return Optional.of(f1);
        }
        if (f1.equals(f2)) {
            return Optional.of(this.empty());
        }
        return this.checkBinaryCache(f1, f2, ZDDAlgorithm.ZddOps.DIFF.ordinal());
    }

    @Override
    public V intersection(V f1, V f2) {
        return (V)this.intersectsCheck(f1, f2).orElseGet(() -> {
            DD res = this.level(f1) < this.level(f2) ? this.intersection(this.getLow(f1), f2) : (this.level(f1) == this.level(f2) ? this.makeNode(this.intersection(this.getLow(f1), this.getLow(f2)), this.intersection(this.getHigh(f1), this.getHigh(f2)), f2.getVariable()) : this.intersection(f1, this.getLow(f2)));
            this.cacheBinaryItem(f1, f2, ZDDAlgorithm.ZddOps.INTSEC.ordinal(), res);
            return res;
        });
    }

    protected Optional<V> intersectsCheck(V f1, V f2) {
        if (f1.equals(this.empty())) {
            return Optional.of(this.empty());
        }
        if (f2.equals(this.empty())) {
            return Optional.of(this.empty());
        }
        if (f1.equals(f2)) {
            return Optional.of(f1);
        }
        return this.checkBinaryCache(f1, f2, ZDDAlgorithm.ZddOps.INTSEC.ordinal());
    }

    @Override
    public V product(V f1, V f2) {
        V res;
        Optional<V> check = this.productCheck(f1, f2);
        if (check.isPresent()) {
            return (V)((DD)check.get());
        }
        if (this.level(f1) > this.level(f2)) {
            res = this.makeNode(this.product(f1, this.getLow(f2)), this.product(f1, this.getHigh(f2)), f2.getVariable());
        } else if (this.level(f1) < this.level(f2)) {
            res = this.makeNode(this.product(this.getLow(f1), f2), this.product(this.getHigh(f1), f2), f1.getVariable());
        } else {
            V high = this.product(this.getHigh(f1), this.getHigh(f2));
            V low = this.product(this.getHigh(f1), this.getLow(f2));
            res = this.product(high, low);
            high = this.product(this.getLow(f1), this.getHigh(f2));
            high = this.product(res, high);
            low = this.product(this.getLow(f1), this.getLow(f2));
            res = this.makeNode(low, high, f1.getVariable());
        }
        this.cacheBinaryItem(f1, f2, ZDDAlgorithm.ZddOps.MUL.ordinal(), res);
        return res;
    }

    protected Optional<V> productCheck(V f1, V f2) {
        if (f1.equals(this.empty()) || f2.equals(this.empty())) {
            return Optional.of(this.empty());
        }
        if (f1.equals(this.base())) {
            return Optional.of(f2);
        }
        if (f2.equals(this.base())) {
            return Optional.of(f1);
        }
        return this.checkBinaryCache(f1, f2, ZDDAlgorithm.ZddOps.MUL.ordinal());
    }

    @Override
    public V modulo(V zdd1, V zdd2) {
        return (V)this.checkBinaryCache(zdd1, zdd2, ZDDAlgorithm.ZddOps.MOD.ordinal()).orElseGet(() -> {
            DD result = this.difference(zdd1, this.product(zdd2, this.difference(zdd1, zdd2)));
            this.cacheBinaryItem(zdd1, zdd2, ZDDAlgorithm.ZddOps.MUL.ordinal(), result);
            return result;
        });
    }

    @Override
    public V division(V f1, V f2) {
        Optional<V> check = this.divisionCheck(f1, f2);
        if (check.isPresent()) {
            return (V)((DD)check.get());
        }
        V res = this.level(f1) < this.level(f2) ? this.makeNode(this.division(this.getLow(f1), f2), this.division(this.getHigh(f1), f2), f1.getVariable()) : this.sequentialDivisionCase(f1, f2);
        this.cacheBinaryItem(f1, f2, ZDDAlgorithm.ZddOps.DIV.ordinal(), res);
        return res;
    }

    protected V sequentialDivisionCase(V f1, V f2) {
        V res = this.division(this.getHigh(f1), this.getHigh(f2));
        V tmp = this.getLow(f2);
        if (!res.isFalse() && !tmp.isFalse()) {
            tmp = this.division(this.getLow(f1), tmp);
            res = this.intersection(tmp, res);
        }
        return res;
    }

    protected Optional<V> divisionCheck(V f1, V f2) {
        if (f1.equals(this.empty()) || f1.equals(this.base())) {
            return Optional.of(this.empty());
        }
        if (f1.equals(f2)) {
            return Optional.of(this.base());
        }
        if (f2.equals(this.base())) {
            return Optional.of(f1);
        }
        if (this.level(f2) < this.level(f1)) {
            return Optional.of(this.empty());
        }
        return this.checkBinaryCache(f1, f2, ZDDAlgorithm.ZddOps.DIV.ordinal());
    }

    @Override
    public V exclude(V f1, V f2) {
        V res;
        Optional<V> check = this.excludeCheck(f1, f2);
        if (check.isPresent()) {
            return (V)((DD)check.get());
        }
        if (this.level(f1) > this.level(f2)) {
            res = this.exclude(f1, this.getLow(f2));
        } else if (this.level(f1) < this.level(f2)) {
            res = this.makeNode(this.exclude(this.getLow(f1), f2), this.exclude(this.getHigh(f1), f2), f1.getVariable());
        } else {
            V low;
            V high;
            if (this.followLow(this.getHigh(f2)).equals(this.base())) {
                high = this.empty();
            } else {
                high = this.exclude(this.getHigh(f1), this.getLow(f2));
                low = this.exclude(this.getHigh(f1), this.getHigh(f2));
                high = this.intersection(high, low);
            }
            low = this.exclude(this.getLow(f1), this.getLow(f2));
            res = this.makeNode(low, high, f1.getVariable());
        }
        this.cacheBinaryItem(f1, f2, ZDDAlgorithm.ZddOps.EXCLUDE.ordinal(), res);
        return res;
    }

    protected Optional<V> excludeCheck(V f1, V f2) {
        if (f1.equals(this.empty()) || f2.equals(this.base()) || f1.equals(f2)) {
            return Optional.of(this.empty());
        }
        if (f1.equals(this.base()) || f2.equals(this.empty())) {
            return Optional.of(f1);
        }
        return this.checkBinaryCache(f1, f2, ZDDAlgorithm.ZddOps.EXCLUDE.ordinal());
    }

    @Override
    public V restrict(V f1, V f2) {
        V res;
        Optional<V> check = this.restrictCheck(f1, f2);
        if (check.isPresent()) {
            return (V)((DD)check.get());
        }
        if (this.level(f1) > this.level(f2)) {
            res = this.restrict(f1, this.getLow(f2));
        } else if (this.level(f1) < this.level(f2)) {
            res = this.makeNode(this.restrict(this.getLow(f1), f2), this.restrict(this.getHigh(f1), f2), f1.getVariable());
        } else {
            V low = this.restrict(this.getHigh(f1), this.getLow(f2));
            V high = this.restrict(this.getHigh(f1), this.getHigh(f2));
            high = this.union(high, low);
            low = this.restrict(this.getLow(f1), this.getLow(f2));
            res = this.makeNode(low, high, f1.getVariable());
        }
        this.cacheBinaryItem(f1, f2, ZDDAlgorithm.ZddOps.RESTRICT.ordinal(), res);
        return res;
    }

    @Override
    public V empty() {
        return this.nodeManager.getFalse();
    }

    @Override
    public V base() {
        return this.nodeManager.getTrue();
    }

    @Override
    public void shutdown() {
        this.computedTable.clear();
    }

    protected Optional<V> restrictCheck(V f1, V f2) {
        if (f1.equals(this.empty()) || f2.equals(this.empty())) {
            return Optional.of(this.empty());
        }
        if (f1.equals(f2)) {
            return Optional.of(f1);
        }
        return this.checkBinaryCache(f1, f2, ZDDAlgorithm.ZddOps.RESTRICT.ordinal());
    }

    protected V followLow(V bdd) {
        V copy = bdd;
        while (!copy.isLeaf()) {
            copy = this.getLow(copy);
        }
        return copy;
    }

    protected Optional<V> operationCheck(V f1, V f2, ZDDAlgorithm.ZddOps op) {
        switch (op) {
            case UNION: {
                return this.unionCheck(f1, f2);
            }
            case DIFF: {
                return this.differenceCheck(f1, f2);
            }
            case INTSEC: {
                return this.intersectsCheck(f1, f2);
            }
            case MUL: {
                return this.productCheck(f1, f2);
            }
            case EXCLUDE: {
                return this.excludeCheck(f1, f2);
            }
            case RESTRICT: {
                return this.restrictCheck(f1, f2);
            }
            case DIV: {
                return this.divisionCheck(f1, f2);
            }
            case CHANGE: {
                return this.changeCheck(f1, f2);
            }
            case SUB_SET0: {
                return this.subset0Check(f1, f2);
            }
            case SUB_SET1: {
                return this.subset1Check(f1, f2);
            }
        }
        throw new IllegalArgumentException("Unknown Operation: " + op);
    }

    public String toString() {
        return this.getClass().getSimpleName();
    }
}

