/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.smt.bdd;

import de.uni_freiburg.informatik.ultimate.logic.AnnotatedTerm;
import de.uni_freiburg.informatik.ultimate.logic.ApplicationTerm;
import de.uni_freiburg.informatik.ultimate.logic.ConstantTerm;
import de.uni_freiburg.informatik.ultimate.logic.LetTerm;
import de.uni_freiburg.informatik.ultimate.logic.QuantifiedFormula;
import de.uni_freiburg.informatik.ultimate.logic.Term;
import de.uni_freiburg.informatik.ultimate.logic.TermVariable;
import java.util.ArrayList;
import java.util.List;
import net.sf.javabdd.BDD;
import net.sf.javabdd.BDDFactory;

public class BDDBuilderRecursive {
    public BDD buildRecursive(Term t, List<Term> atoms) {
        BDDFactory factory = BDDFactory.init((String)"java", (int)(atoms.size() + 2), (int)(atoms.size() + 2), (boolean)false);
        factory.setVarNum(atoms.size());
        return this.buildRecursive2(t, factory, atoms);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private BDD buildRecursive2(Term t, BDDFactory factory, List<Term> atoms) {
        if (t instanceof ApplicationTerm) {
            ApplicationTerm term = (ApplicationTerm)t;
            String fName = term.getFunction().getName();
            if (fName.equals("and") || fName.equals("or") || fName.equals("xor") || fName.equals("not") || fName.equals("=>")) {
                BDD result;
                ArrayList<BDD> params = new ArrayList<BDD>();
                Term[] termArray = term.getParameters();
                int n = termArray.length;
                int n2 = 0;
                while (n2 < n) {
                    Term th = termArray[n2];
                    params.add(this.buildRecursive2(th, factory, atoms));
                    ++n2;
                }
                if (fName.equals("and")) {
                    result = (BDD)params.remove(0);
                    for (BDD bdd : params) {
                        result = result.and(bdd);
                    }
                    return result;
                }
                if (fName.equals("or")) {
                    result = (BDD)params.remove(0);
                    for (BDD bdd : params) {
                        result = result.or(bdd);
                    }
                    return result;
                }
                if (fName.equals("xor")) {
                    result = (BDD)params.remove(0);
                    for (BDD bdd : params) {
                        result = result.xor(bdd);
                    }
                    return result;
                }
                if (fName.equals("=>")) {
                    result = (BDD)params.remove(0);
                    for (BDD bdd : params) {
                        result = result.imp(bdd);
                    }
                    return result;
                }
                if (!fName.equals("not")) throw new UnsupportedOperationException(t.toString());
                return ((BDD)params.get(0)).not();
            }
            if (fName.equals("true")) {
                return factory.one();
            }
            if (!fName.equals("false")) return factory.ithVar(atoms.indexOf(term));
            return factory.zero();
        }
        if (t instanceof LetTerm) {
            return factory.ithVar(atoms.indexOf(t));
        }
        if (t instanceof AnnotatedTerm) {
            return this.buildRecursive2(((AnnotatedTerm)t).getSubterm(), factory, atoms);
        }
        if (t instanceof QuantifiedFormula) {
            return factory.ithVar(atoms.indexOf(t));
        }
        if (t instanceof ConstantTerm) {
            return factory.ithVar(atoms.indexOf(t));
        }
        if (!(t instanceof TermVariable)) throw new UnsupportedOperationException(t.toString());
        return factory.ithVar(atoms.indexOf(t));
    }
}

