/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.smt.bdd;

import de.uni_freiburg.informatik.ultimate.logic.AnnotatedTerm;
import de.uni_freiburg.informatik.ultimate.logic.ApplicationTerm;
import de.uni_freiburg.informatik.ultimate.logic.NonRecursive;
import de.uni_freiburg.informatik.ultimate.logic.Term;
import java.util.ArrayList;
import java.util.List;
import net.sf.javabdd.BDD;
import net.sf.javabdd.BDDFactory;

public class BddBuilder
extends NonRecursive {
    private BDD mResult;

    public BDD buildBDD(Term in, List<Term> atoms) {
        BDDFactory factory = BDDFactory.init((String)"java", (int)(atoms.size() + 2), (int)(atoms.size() + 2), (boolean)false);
        factory.setVarNum(atoms.size());
        this.run(new Walker(in, factory, atoms, null));
        return this.mResult;
    }

    private class Walker
    implements NonRecursive.Walker {
        private final Term mTerm;
        private final BDDFactory mFactory;
        private final List<Term> mAtoms;
        private final Walker mParent;
        private final List<BDD> mParams;
        private int mCall;

        public Walker(Term t, BDDFactory factory, List<Term> atoms, Walker parent) {
            this.mTerm = t;
            this.mFactory = factory;
            this.mAtoms = atoms;
            this.mParent = parent;
            this.mCall = 0;
            this.mParams = new ArrayList<BDD>();
        }

        public void ret(BDD bdd) {
            if (this.mParent != null) {
                this.mParent.mParams.add(bdd);
            } else {
                BddBuilder.this.mResult = bdd;
            }
        }

        public void walk(NonRecursive engine) {
            if (this.mTerm instanceof ApplicationTerm) {
                ApplicationTerm term = (ApplicationTerm)this.mTerm;
                String fName = term.getFunction().getName();
                if (fName.equals("and") || fName.equals("or") || fName.equals("xor") || fName.equals("not") || fName.equals("=>")) {
                    if (this.mCall == 0) {
                        engine.enqueueWalker((NonRecursive.Walker)this);
                        Term[] termArray = term.getParameters();
                        int n = termArray.length;
                        int n2 = 0;
                        while (n2 < n) {
                            Term th = termArray[n2];
                            Walker w = new Walker(th, this.mFactory, this.mAtoms, this);
                            engine.enqueueWalker((NonRecursive.Walker)w);
                            ++n2;
                        }
                        ++this.mCall;
                        return;
                    }
                    if (this.mCall == 1) {
                        if (fName.equals("and")) {
                            BDD result = this.mParams.remove(0);
                            for (BDD bdd : this.mParams) {
                                result = result.and(bdd);
                            }
                            this.ret(result);
                        } else if (fName.equals("or")) {
                            BDD result = this.mParams.remove(0);
                            for (BDD bdd : this.mParams) {
                                result = result.or(bdd);
                            }
                            this.ret(result);
                        } else if (fName.equals("xor")) {
                            BDD result = this.mParams.remove(0);
                            for (BDD bdd : this.mParams) {
                                result = result.xor(bdd);
                            }
                            this.ret(result);
                        } else if (fName.equals("=>")) {
                            BDD result = this.mParams.remove(0);
                            for (BDD bdd : this.mParams) {
                                result = result.imp(bdd);
                            }
                            this.ret(result);
                        } else if (fName.equals("not")) {
                            BDD bdd = this.mParams.remove(0).not();
                            this.ret(bdd);
                        }
                    }
                } else if (fName.equals("true")) {
                    BDD bdd = this.mFactory.one();
                    this.ret(bdd);
                } else if (fName.equals("false")) {
                    BDD bdd = this.mFactory.zero();
                    this.ret(bdd);
                } else {
                    BDD bdd = this.mFactory.ithVar(this.mAtoms.indexOf(this.mTerm));
                    this.ret(bdd);
                }
            } else if (this.mTerm instanceof AnnotatedTerm) {
                if (this.mCall == 0) {
                    engine.enqueueWalker((NonRecursive.Walker)this);
                    Walker w = new Walker(((AnnotatedTerm)this.mTerm).getSubterm(), this.mFactory, this.mAtoms, this);
                    engine.enqueueWalker((NonRecursive.Walker)w);
                    ++this.mCall;
                    return;
                }
                if (this.mCall == 1) {
                    BDD bdd = this.mParams.get(0);
                    this.ret(bdd);
                }
            } else {
                BDD bdd = this.mFactory.ithVar(this.mAtoms.indexOf(this.mTerm));
                this.ret(bdd);
            }
        }
    }
}

