/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.smt.bdd;

import de.uni_freiburg.informatik.ultimate.core.model.services.ILogger;
import de.uni_freiburg.informatik.ultimate.core.model.services.IUltimateServiceProvider;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.smt.bdd.BddBuilder;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.smt.bdd.CollectAtoms;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.ManagedScript;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.SmtLibUtils;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.SmtUtils;
import de.uni_freiburg.informatik.ultimate.logic.Script;
import de.uni_freiburg.informatik.ultimate.logic.Term;
import de.uni_freiburg.informatik.ultimate.logic.Util;
import de.uni_freiburg.informatik.ultimate.util.datastructures.relation.Pair;
import java.util.ArrayList;
import java.util.List;
import net.sf.javabdd.BDD;

public class SimplifyBdd {
    private final IUltimateServiceProvider mServices;
    private final Script mScript;
    private final ILogger mLogger;
    private final ManagedScript mMgdScript;

    public SimplifyBdd(IUltimateServiceProvider services, ManagedScript mgdScript) {
        this.mServices = services;
        this.mLogger = services.getLoggingService().getLogger(SmtLibUtils.PLUGIN_ID);
        this.mScript = mgdScript.getScript();
        this.mMgdScript = mgdScript;
    }

    public Term transform(Term input) {
        CollectAtoms ca = new CollectAtoms();
        List<Term> atoms = ca.getTerms(input);
        BddBuilder bb = new BddBuilder();
        BDD d = bb.buildBDD(input, atoms);
        Term result = this.bddToTerm(d, atoms);
        assert (this.assertSimplificationSound(input, result)) : "simplification unsound";
        return result;
    }

    private boolean assertSimplificationSound(Term input, Term result) {
        boolean isSound;
        boolean bl = isSound = Util.checkSat((Script)this.mScript, (Term)this.mScript.term("distinct", new Term[]{input, result})) != Script.LBool.SAT;
        if (isSound) {
            return true;
        }
        this.mLogger.fatal((Object)"Simplification failed");
        this.mLogger.fatal((Object)("Input:             " + input));
        this.mLogger.fatal((Object)("Output:            " + result));
        this.mLogger.fatal((Object)("Simplified output: " + SmtUtils.simplify(this.mMgdScript, result, this.mServices, SmtUtils.SimplificationTechnique.SIMPLIFY_DDA)));
        return false;
    }

    public Term transformWithImplications(Term input) {
        CollectAtoms ca = new CollectAtoms();
        List<Term> atoms = ca.getTerms(input);
        BddBuilder bb = new BddBuilder();
        BDD d = bb.buildBDD(input, atoms);
        return this.bddToTerm(d, atoms);
    }

    private Term bddToTerm(BDD d, List<Term> atoms) {
        if (d.isOne()) {
            return this.mScript.term("true", new Term[0]);
        }
        if (d.isZero()) {
            return this.mScript.term("false", new Term[0]);
        }
        Term low = this.bddToTerm(d.low(), atoms);
        Term high = this.bddToTerm(d.high(), atoms);
        if (SmtUtils.isFalseLiteral(low) && SmtUtils.isFalseLiteral(high)) {
            return low;
        }
        if (SmtUtils.isFalseLiteral(high)) {
            if (SmtUtils.isTrueLiteral(low)) {
                return this.mScript.term("not", new Term[]{atoms.get(d.var())});
            }
            return this.mScript.term("and", new Term[]{this.mScript.term("not", new Term[]{atoms.get(d.var())}), low});
        }
        if (SmtUtils.isFalseLiteral(low)) {
            if (SmtUtils.isTrueLiteral(high)) {
                return atoms.get(d.var());
            }
            return this.mScript.term("and", new Term[]{atoms.get(d.var()), high});
        }
        return this.mScript.term("or", new Term[]{this.mScript.term("and", new Term[]{atoms.get(d.var()), high}), this.mScript.term("and", new Term[]{this.mScript.term("not", new Term[]{atoms.get(d.var())}), low})});
    }

    public Term transformToDNF(Term input) {
        CollectAtoms ca = new CollectAtoms();
        List<Term> atoms = ca.getTerms(input);
        assert (!atoms.isEmpty()) : "How did I not find any atoms? " + input;
        BddBuilder bb = new BddBuilder();
        BDD d = bb.buildBDD(input, atoms);
        ArrayList<Term> con = new ArrayList<Term>();
        for (byte[] t : d.allsat()) {
            ArrayList<Term> lit = new ArrayList<Term>();
            int i = 0;
            while (i < t.length) {
                if (t[i] == 0) {
                    lit.add(SmtUtils.not(this.mScript, atoms.get(i)));
                } else if (t[i] == 1) {
                    lit.add(atoms.get(i));
                }
                ++i;
            }
            con.add(SmtUtils.and(this.mScript, lit));
        }
        Term result = SmtUtils.or(this.mScript, con);
        assert (this.assertSimplificationSound(input, result)) : "DNF transformation unsound. Input: " + input;
        return result;
    }

    public Term transformToCNF(Term input) {
        CollectAtoms ca = new CollectAtoms();
        List<Term> atoms = ca.getTerms(input);
        BddBuilder bb = new BddBuilder();
        BDD d = bb.buildBDD(input, atoms).not();
        ArrayList<Term> dis = new ArrayList<Term>();
        for (byte[] t : d.allsat()) {
            ArrayList<Term> lit = new ArrayList<Term>();
            int i = 0;
            while (i < t.length) {
                if (t[i] == 1) {
                    lit.add(SmtUtils.not(this.mScript, atoms.get(i)));
                } else if (t[i] == 0) {
                    lit.add(atoms.get(i));
                }
                ++i;
            }
            dis.add(SmtUtils.or(this.mScript, lit));
        }
        Term result = SmtUtils.and(this.mScript, dis);
        assert (this.assertSimplificationSound(input, result)) : "CNF transformation unsound. Input: " + input;
        return result;
    }

    private boolean implies(Term t1, Term t2) {
        this.mScript.push(1);
        this.mScript.assertTerm(t1);
        this.mScript.assertTerm(SmtUtils.not(this.mScript, t2));
        Script.LBool result = this.mScript.checkSat();
        this.mScript.pop(1);
        return result == Script.LBool.UNSAT;
    }

    public List<Pair<Term, Term>> impliesPairwise(List<Term> in) {
        ArrayList<Pair<Term, Term>> res = new ArrayList<Pair<Term, Term>>();
        int i = 0;
        while (i < in.size()) {
            this.mScript.push(1);
            this.mScript.assertTerm(in.get(i));
            int j = 0;
            while (j < in.size()) {
                this.mScript.push(1);
                this.mScript.assertTerm(SmtUtils.not(this.mScript, in.get(j)));
                Script.LBool result = this.mScript.checkSat();
                if (result == Script.LBool.UNSAT) {
                    res.add((Pair<Term, Term>)new Pair((Object)in.get(i), (Object)in.get(j)));
                }
                this.mScript.pop(1);
                ++j;
            }
            this.mScript.pop(1);
            ++i;
        }
        return res;
    }
}

