/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.smt.bdd;

import de.uni_freiburg.informatik.ultimate.logic.AnnotatedTerm;
import de.uni_freiburg.informatik.ultimate.logic.ApplicationTerm;
import de.uni_freiburg.informatik.ultimate.logic.ConstantTerm;
import de.uni_freiburg.informatik.ultimate.logic.FunctionSymbol;
import de.uni_freiburg.informatik.ultimate.logic.LetTerm;
import de.uni_freiburg.informatik.ultimate.logic.QuantifiedFormula;
import de.uni_freiburg.informatik.ultimate.logic.QuotedObject;
import de.uni_freiburg.informatik.ultimate.logic.Rational;
import de.uni_freiburg.informatik.ultimate.logic.Sort;
import de.uni_freiburg.informatik.ultimate.logic.Term;
import de.uni_freiburg.informatik.ultimate.logic.TermVariable;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.HashSet;
import java.util.Set;

public class TermCodeBuilder {
    private final Set<Sort> sorts = new HashSet<Sort>();
    private final Set<ConstantTerm> constants = new HashSet<ConstantTerm>();
    private final Set<TermVariable> vars = new HashSet<TermVariable>();
    private final Set<FunctionSymbol> funs = new HashSet<FunctionSymbol>();

    public static String code(Term term) {
        return new TermCodeBuilder().buildCode(term);
    }

    public String buildCode(Term term) {
        String s;
        StringBuilder sb = new StringBuilder();
        this.collect(term);
        sb.append("//Sorts\n");
        for (Sort sort : this.sorts) {
            if (!sort.isInternal()) {
                throw new UnsupportedOperationException("Sorry, I can only give you code for internal sorts");
            }
            s = "Sort sort_" + sort.getName() + " = script.sort(\"" + sort.getName() + "\");\n";
            sb.append(s);
        }
        sb.append("\n");
        sb.append("//Constants\n");
        for (ConstantTerm constant : this.constants) {
            String s2;
            Object iCon;
            Object con = constant.getValue();
            if (con instanceof Rational) {
                iCon = (Rational)con;
                s2 = "Term con_" + iCon.hashCode() + " = Rational.valueOf(new BigInteger(\"" + iCon.numerator().toString() + "\"),new BigInteger(\"" + iCon.denominator().toString() + "\")).toTerm(sort_" + constant.getSort().getName() + ");\n";
                sb.append(s2);
                continue;
            }
            if (con instanceof BigInteger) {
                iCon = (BigInteger)con;
                s2 = "Term con_" + ((BigInteger)iCon).hashCode() + " = script.numeral(\"" + ((BigInteger)iCon).toString() + "\");\n";
                sb.append(s2);
                continue;
            }
            if (con instanceof BigDecimal) {
                iCon = (BigDecimal)con;
                s2 = "Term con_" + ((BigDecimal)iCon).hashCode() + " = script.decimal(\"" + ((BigDecimal)iCon).toString() + "\");\n";
                sb.append(s2);
                continue;
            }
            if (con instanceof QuotedObject) {
                iCon = (QuotedObject)con;
                if (iCon.getValue() instanceof String) {
                    s2 = "Term con_" + iCon.hashCode() + " = script.string(\"" + iCon.getValue() + "\");\n";
                    sb.append(s2);
                    continue;
                }
                throw new UnsupportedOperationException("I don't know what this is: " + iCon.getValue());
            }
            throw new UnsupportedOperationException("I don't know what this is: " + con);
        }
        sb.append("\n");
        sb.append("//Vars\n");
        for (TermVariable var : this.vars) {
            s = "TermVariable " + TermCodeBuilder.buildJavaVariableName(var) + " = script.variable(\"" + var.getName() + "\", sort_" + var.getSort().getName() + ");\n";
            sb.append(s);
        }
        sb.append("\n");
        sb.append("//Functions\n");
        for (FunctionSymbol fun : this.funs) {
            if (fun.isIntern()) continue;
            StringBuilder param = new StringBuilder();
            param.append("new Sort[]{");
            if (fun.getParameterSorts().length > 0) {
                param.append("sort_" + fun.getParameterSorts()[0]);
                int i = 1;
                while (i < fun.getParameterSorts().length) {
                    param.append(", sort_" + fun.getParameterSorts()[i]);
                    ++i;
                }
            }
            param.append("}");
            String s3 = "script.declareFun(\"" + fun.getName() + "\", " + param.toString() + ", sort_" + fun.getReturnSort().getName() + ");\n";
            sb.append(s3);
        }
        sb.append("\n");
        sb.append("//term\n");
        sb.append("Term term = " + this.buildTerm(term) + ";");
        return sb.toString();
    }

    private void collect(Term term) {
        if (term instanceof ApplicationTerm) {
            ApplicationTerm iTerm = (ApplicationTerm)term;
            this.sorts.add(iTerm.getSort());
            Sort[] sortArray = iTerm.getFunction().getParameterSorts();
            int n = sortArray.length;
            int n2 = 0;
            while (n2 < n) {
                Sort sort = sortArray[n2];
                this.sorts.add(sort);
                ++n2;
            }
            this.funs.add(iTerm.getFunction());
            sortArray = iTerm.getParameters();
            n = sortArray.length;
            n2 = 0;
            while (n2 < n) {
                Sort t = sortArray[n2];
                this.collect((Term)t);
                ++n2;
            }
        } else if (term instanceof LetTerm) {
            TermVariable t;
            LetTerm iTerm = (LetTerm)term;
            this.sorts.add(iTerm.getSort());
            TermVariable[] termVariableArray = iTerm.getVariables();
            int n = termVariableArray.length;
            int n3 = 0;
            while (n3 < n) {
                t = termVariableArray[n3];
                this.sorts.add(t.getSort());
                ++n3;
            }
            termVariableArray = iTerm.getVariables();
            n = termVariableArray.length;
            n3 = 0;
            while (n3 < n) {
                t = termVariableArray[n3];
                this.vars.add(t);
                ++n3;
            }
            termVariableArray = iTerm.getValues();
            n = termVariableArray.length;
            n3 = 0;
            while (n3 < n) {
                t = termVariableArray[n3];
                this.collect((Term)t);
                ++n3;
            }
            this.collect(iTerm.getSubTerm());
        } else if (term instanceof AnnotatedTerm) {
            AnnotatedTerm iTerm = (AnnotatedTerm)term;
            this.collect(iTerm.getSubterm());
        } else if (term instanceof QuantifiedFormula) {
            TermVariable t;
            QuantifiedFormula iTerm = (QuantifiedFormula)term;
            this.sorts.add(iTerm.getSort());
            TermVariable[] termVariableArray = iTerm.getVariables();
            int n = termVariableArray.length;
            int n4 = 0;
            while (n4 < n) {
                t = termVariableArray[n4];
                this.sorts.add(t.getSort());
                ++n4;
            }
            termVariableArray = iTerm.getVariables();
            n = termVariableArray.length;
            n4 = 0;
            while (n4 < n) {
                t = termVariableArray[n4];
                this.vars.add(t);
                ++n4;
            }
            this.collect(iTerm.getSubformula());
        } else if (term instanceof ConstantTerm) {
            ConstantTerm iTerm = (ConstantTerm)term;
            this.sorts.add(iTerm.getSort());
            this.constants.add(iTerm);
        } else if (term instanceof TermVariable) {
            TermVariable iTerm = (TermVariable)term;
            this.sorts.add(iTerm.getSort());
            this.vars.add(iTerm);
        }
    }

    private String buildTerm(Term term) {
        StringBuilder sb = new StringBuilder();
        if (term instanceof ApplicationTerm) {
            ApplicationTerm iTerm = (ApplicationTerm)term;
            sb.append("script.term(\"" + iTerm.getFunction().getName() + "\"");
            Term[] termArray = iTerm.getParameters();
            int n = termArray.length;
            int n2 = 0;
            while (n2 < n) {
                Term t = termArray[n2];
                sb.append(", " + this.buildTerm(t));
                ++n2;
            }
            sb.append(")");
        } else if (term instanceof LetTerm) {
            int i;
            LetTerm iTerm = (LetTerm)term;
            sb.append("script.let(");
            sb.append("new TermVariable[]{");
            if (iTerm.getVariables().length > 0) {
                sb.append(TermCodeBuilder.buildJavaVariableName(iTerm.getVariables()[0]));
                i = 1;
                while (i < iTerm.getVariables().length) {
                    sb.append(", " + TermCodeBuilder.buildJavaVariableName(iTerm.getVariables()[0]));
                    ++i;
                }
            }
            sb.append("}, new Term[]{");
            if (iTerm.getValues().length > 0) {
                sb.append(this.buildTerm(iTerm.getValues()[0]));
                i = 1;
                while (i < iTerm.getValues().length) {
                    sb.append(", " + this.buildTerm(iTerm.getValues()[i]));
                    ++i;
                }
            }
            sb.append("}, " + this.buildTerm(iTerm.getSubTerm()) + ")");
        } else if (term instanceof AnnotatedTerm) {
            AnnotatedTerm iTerm = (AnnotatedTerm)term;
            sb.append(this.buildTerm(iTerm.getSubterm()));
        } else if (term instanceof QuantifiedFormula) {
            QuantifiedFormula iTerm = (QuantifiedFormula)term;
            sb.append("script.quantifier(" + iTerm.getQuantifier() + ", ");
            sb.append("new TermVariable[]{");
            if (iTerm.getVariables().length > 0) {
                sb.append(TermCodeBuilder.buildJavaVariableName(iTerm.getVariables()[0]));
                int i = 0;
                while (i < iTerm.getVariables().length) {
                    sb.append(", " + TermCodeBuilder.buildJavaVariableName(iTerm.getVariables()[0]));
                    ++i;
                }
            }
            sb.append("}, ");
            sb.append(this.buildTerm(iTerm.getSubformula()));
            sb.append(")");
        } else if (term instanceof ConstantTerm) {
            ConstantTerm iTerm = (ConstantTerm)term;
            sb.append("con_" + iTerm.getValue().hashCode());
        } else if (term instanceof TermVariable) {
            TermVariable iTerm = (TermVariable)term;
            sb.append(TermCodeBuilder.buildJavaVariableName(iTerm));
        }
        return sb.toString();
    }

    private static String buildJavaVariableName(TermVariable tv) {
        return "var_" + tv.getName().replaceAll("[.()#~]", "");
    }
}

