/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.smt.scripttransfer;

import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.smt.scripttransfer.ISmtDeclarable;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.smt.scripttransfer.NonDeclaringTermTransferrer;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.UltimateNormalFormUtils;
import de.uni_freiburg.informatik.ultimate.logic.PrintTerm;
import de.uni_freiburg.informatik.ultimate.logic.QuantifiedFormula;
import de.uni_freiburg.informatik.ultimate.logic.Script;
import de.uni_freiburg.informatik.ultimate.logic.Sort;
import de.uni_freiburg.informatik.ultimate.logic.Term;
import de.uni_freiburg.informatik.ultimate.logic.TermVariable;
import de.uni_freiburg.informatik.ultimate.smtsolver.external.TermParseUtils;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Objects;

public final class DeclarableFunctionSymbol
implements ISmtDeclarable {
    private final String mId;
    private final String[] mParamIds;
    private final Sort[] mParamSorts;
    private final Sort mResultSort;
    private final Term mFunctionDefinition;
    private Term[] mParamVars;

    public DeclarableFunctionSymbol(String smtID, Sort[] paramSorts, Sort resultSort) {
        this(smtID, null, paramSorts, resultSort, null);
    }

    public DeclarableFunctionSymbol(String smtID, String[] paramIds, Sort[] paramSorts, Sort resultSort, Term subformula) {
        this.mId = Objects.requireNonNull(smtID);
        this.mParamSorts = Objects.requireNonNull(paramSorts);
        this.mResultSort = Objects.requireNonNull(resultSort);
        this.mParamIds = paramIds;
        this.mFunctionDefinition = subformula;
    }

    public static DeclarableFunctionSymbol createFromScriptDefineFun(String fun, TermVariable[] params, Sort resultSort, Term definition) {
        String[] paramIds = new String[params.length];
        Sort[] paramSorts = new Sort[params.length];
        int i = 0;
        while (i < params.length) {
            paramIds[i] = params[i].getName();
            paramSorts[i] = params[i].getSort();
            ++i;
        }
        return new DeclarableFunctionSymbol(fun, paramIds, paramSorts, resultSort, definition);
    }

    public static DeclarableFunctionSymbol createFromScriptDeclareFun(String fun, Sort[] paramSorts, Sort resultSort) {
        return new DeclarableFunctionSymbol(fun, paramSorts, resultSort);
    }

    public static DeclarableFunctionSymbol createFromString(Script script, String smtFunName, String smtFunBody, String[] paramIds, Sort[] paramSorts, Sort resultSort) {
        Term bodyTerm;
        if (smtFunBody == null) {
            return new DeclarableFunctionSymbol(smtFunName, paramSorts, resultSort);
        }
        if (paramIds.length == 0) {
            bodyTerm = TermParseUtils.parseTerm((Script)script, (String)smtFunBody);
        } else {
            StringBuilder sb = new StringBuilder();
            sb.append("(forall (");
            int i = 0;
            while (i < paramIds.length) {
                sb.append("(");
                sb.append(paramIds[i]);
                sb.append(" ");
                sb.append(paramSorts[i]);
                sb.append(")");
                ++i;
            }
            sb.append(") ");
            sb.append(smtFunBody);
            sb.append(")");
            QuantifiedFormula term = (QuantifiedFormula)TermParseUtils.parseTerm((Script)script, (String)sb.toString());
            bodyTerm = term.getSubformula();
            assert (UltimateNormalFormUtils.respectsUltimateNormalForm(bodyTerm)) : "SMT function body not in Ultimate normal form";
        }
        return new DeclarableFunctionSymbol(smtFunName, paramIds, paramSorts, resultSort, bodyTerm);
    }

    @Override
    public void defineOrDeclare(Script script) {
        NonDeclaringTermTransferrer tt = new NonDeclaringTermTransferrer(script);
        Sort[] newParamSorts = tt.transferSorts(this.mParamSorts);
        Sort newResultSort = tt.transferSort(this.mResultSort);
        if (this.mFunctionDefinition == null) {
            script.declareFun(this.mId, newParamSorts, newResultSort);
        } else {
            TermVariable[] params = new TermVariable[this.mParamSorts.length];
            int i = 0;
            while (i < this.mParamSorts.length) {
                if (this.mParamIds[i] == null) {
                    throw new ISmtDeclarable.IllegalSmtDeclarableUsageException("Unnamed parameter in function declaration together with smtdefined attribute");
                }
                params[i] = script.variable(this.mParamIds[i], newParamSorts[i]);
                ++i;
            }
            Term fundef = new NonDeclaringTermTransferrer(script).transform(this.mFunctionDefinition);
            script.defineFun(this.mId, params, newResultSort, fundef);
        }
    }

    public Term getDefinition() {
        return this.mFunctionDefinition;
    }

    @Override
    public String getName() {
        return this.mId;
    }

    public String[] getParamIds() {
        return this.mParamIds;
    }

    public Sort[] getParamSorts() {
        return this.mParamSorts;
    }

    public Sort getResultSort() {
        return this.mResultSort;
    }

    public Term[] getParamVars() {
        if (this.mParamVars == null) {
            this.mParamVars = this.computeParamVars();
        }
        return this.mParamVars;
    }

    private Term[] computeParamVars() {
        if (this.mFunctionDefinition == null) {
            throw new ISmtDeclarable.IllegalSmtDeclarableUsageException("Cannot compute parameter vars if there is no body");
        }
        HashMap freeVars = new HashMap();
        Arrays.stream(this.mFunctionDefinition.getFreeVars()).forEach(a -> {
            TermVariable termVariable = freeVars.put(a.getName(), a);
        });
        this.mParamVars = new Term[this.mParamIds.length];
        int i = 0;
        while (i < this.mParamIds.length) {
            this.mParamVars[i] = (Term)freeVars.get(this.mParamIds[i]);
            ++i;
        }
        return this.mParamVars;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        String name = PrintTerm.quoteIdentifier((String)this.mId);
        sb.append('(').append(name);
        Sort[] sortArray = this.mParamSorts;
        int n = this.mParamSorts.length;
        int n2 = 0;
        while (n2 < n) {
            Sort s = sortArray[n2];
            sb.append(' ').append(s);
            ++n2;
        }
        sb.append(' ').append(this.mResultSort);
        sb.append(')');
        return sb.toString();
    }
}

