/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.smt.scripttransfer;

import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.smt.scripttransfer.ISmtDeclarable;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.smt.scripttransfer.NonDeclaringTermTransferrer;
import de.uni_freiburg.informatik.ultimate.logic.PrintTerm;
import de.uni_freiburg.informatik.ultimate.logic.Script;
import de.uni_freiburg.informatik.ultimate.logic.Sort;
import java.util.Arrays;
import java.util.Objects;

public class DeclarableSortSymbol
implements ISmtDeclarable {
    private final String mName;
    private final int mArity;
    private final Sort[] mParams;
    private final Sort mDefinition;

    private DeclarableSortSymbol(String name, Sort[] params, Sort definition, int arity) {
        this.mName = Objects.requireNonNull(name);
        this.mParams = params;
        this.mDefinition = definition;
        this.mArity = arity;
        assert (this.mParams == null || this.mParams.length == arity);
        assert (params == null || Arrays.stream(params).allMatch(a -> a != null));
    }

    public static DeclarableSortSymbol createFromScriptDefineSort(String sort, Sort[] sortParams, Sort definition) {
        return new DeclarableSortSymbol(sort, sortParams, definition, sortParams == null ? 0 : sortParams.length);
    }

    public static ISmtDeclarable createFromScriptDeclareSort(String sort, int arity) {
        return new DeclarableSortSymbol(sort, null, null, arity);
    }

    @Override
    public void defineOrDeclare(Script script) {
        NonDeclaringTermTransferrer ndtt = new NonDeclaringTermTransferrer(script);
        if (this.mDefinition == null && this.mParams == null) {
            script.declareSort(this.mName, this.mArity);
            return;
        }
        Sort[] newParams = this.mParams == null ? null : ndtt.transferSorts(this.mParams);
        Sort newDef = this.mDefinition == null ? null : ndtt.transferSort(this.mDefinition);
        script.defineSort(this.mName, newParams, newDef);
    }

    @Override
    public String getName() {
        return this.mName;
    }

    public String toString() {
        return "(" + PrintTerm.quoteIdentifier((String)this.mName) + " " + this.mArity + ")";
    }
}

