/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.smt.scripttransfer;

import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.smt.scripttransfer.DeclarableFunctionSymbol;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.smt.scripttransfer.DeclarableSortSymbol;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.smt.scripttransfer.ISmtDeclarable;
import de.uni_freiburg.informatik.ultimate.logic.SMTLIBException;
import de.uni_freiburg.informatik.ultimate.logic.Script;
import de.uni_freiburg.informatik.ultimate.logic.Sort;
import de.uni_freiburg.informatik.ultimate.logic.Term;
import de.uni_freiburg.informatik.ultimate.logic.TermVariable;
import de.uni_freiburg.informatik.ultimate.logic.WrapperScript;
import java.util.ArrayDeque;
import java.util.Collections;
import java.util.Deque;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Map;

public class HistoryRecordingScript
extends WrapperScript {
    private final Deque<ISmtDeclarable> mHistory = new ArrayDeque<ISmtDeclarable>();
    private final Map<String, ISmtDeclarable> mSymbolTable = new Hashtable<String, ISmtDeclarable>();
    private int mCurrentStackLevel = 0;

    public HistoryRecordingScript(Script script) {
        super(script);
    }

    public void defineFun(String fun, TermVariable[] params, Sort resultSort, Term definition) throws SMTLIBException {
        super.defineFun(fun, params, resultSort, definition);
        this.insert(DeclarableFunctionSymbol.createFromScriptDefineFun(fun, params, resultSort, definition));
    }

    public void resetAssertions() {
        super.resetAssertions();
        this.removeStackLevelsFromHistory(this.mCurrentStackLevel);
    }

    public void reset() {
        super.reset();
        this.mHistory.clear();
        this.mSymbolTable.clear();
    }

    public void defineSort(String sort, Sort[] sortParams, Sort definition) {
        super.defineSort(sort, sortParams, definition);
        this.insert(DeclarableSortSymbol.createFromScriptDefineSort(sort, sortParams, definition));
    }

    public void declareFun(String fun, Sort[] paramSorts, Sort resultSort) {
        super.declareFun(fun, paramSorts, resultSort);
        this.insert(DeclarableFunctionSymbol.createFromScriptDeclareFun(fun, paramSorts, resultSort));
    }

    public void declareSort(String sort, int arity) {
        super.declareSort(sort, arity);
        this.insert(DeclarableSortSymbol.createFromScriptDeclareSort(sort, arity));
    }

    public void push(int levels) {
        super.push(levels);
        assert (levels > 0);
        int i = 0;
        while (i < levels) {
            this.mHistory.push(StackMarker.INSTANCE);
            ++i;
        }
        this.mCurrentStackLevel += levels;
    }

    public void pop(int levels) {
        super.pop(levels);
        this.removeStackLevelsFromHistory(levels);
    }

    /*
     * Unable to fully structure code
     */
    private void removeStackLevelsFromHistory(int levels) {
        if (!HistoryRecordingScript.$assertionsDisabled && levels <= 0) {
            throw new AssertionError();
        }
        iter = this.mHistory.iterator();
        markerCount = 0;
        i = 0;
        ** GOTO lbl19
        {
            block6: {
                current = iter.next();
                iter.remove();
                if (current != StackMarker.INSTANCE) break block6;
                ++markerCount;
                ** GOTO lbl18
            }
            old = this.mSymbolTable.remove(current.getName());
            if (!HistoryRecordingScript.$assertionsDisabled && old == null) {
                throw new AssertionError();
            }
            do {
                if (iter.hasNext()) continue block0;
lbl18:
                // 2 sources

                ++i;
lbl19:
                // 2 sources

            } while (i < levels);
        }
        if (!HistoryRecordingScript.$assertionsDisabled && markerCount != levels) {
            throw new AssertionError();
        }
        this.mCurrentStackLevel -= levels;
        if (this.mCurrentStackLevel < 0) {
            this.mCurrentStackLevel = 0;
        }
    }

    private void insert(ISmtDeclarable declarable) {
        this.mHistory.push(declarable);
        ISmtDeclarable old = this.mSymbolTable.put(declarable.getName(), declarable);
        assert (old == null) : "overwriting already existing symbol in history: " + old;
    }

    public void transferHistoryFromRecord(Script script) {
        Iterator<ISmtDeclarable> iter = this.mHistory.descendingIterator();
        while (iter.hasNext()) {
            ISmtDeclarable elem = iter.next();
            if (elem instanceof StackMarker) {
                script.push(1);
                continue;
            }
            elem.defineOrDeclare(script);
        }
    }

    public static void transferHistoryFromRecord(Script oldScript, Script newScript) {
        HistoryRecordingScript hrScript = HistoryRecordingScript.extractHistoryRecordingScript(oldScript);
        if (hrScript == null) {
            throw new ISmtDeclarable.IllegalSmtDeclarableUsageException("There is no " + HistoryRecordingScript.class + " script in " + oldScript);
        }
        hrScript.transferHistoryFromRecord(newScript);
    }

    public static HistoryRecordingScript extractHistoryRecordingScript(Script script) {
        if (script instanceof HistoryRecordingScript) {
            return (HistoryRecordingScript)script;
        }
        if (script instanceof WrapperScript) {
            return (HistoryRecordingScript)((WrapperScript)script).findBacking(HistoryRecordingScript.class);
        }
        return null;
    }

    public Map<String, ISmtDeclarable> getSymbolTable() {
        return Collections.unmodifiableMap(this.mSymbolTable);
    }

    public String toString() {
        return String.valueOf(((Object)((Object)this)).getClass().getSimpleName()) + ": " + this.mHistory;
    }

    private static final class StackMarker
    implements ISmtDeclarable {
        private static final StackMarker INSTANCE = new StackMarker();

        private StackMarker() {
        }

        @Override
        public void defineOrDeclare(Script script) {
            throw new UnsupportedOperationException(String.valueOf(this.getClass().getName()) + " only marks stacks, it cannot be defined or declared");
        }

        @Override
        public String getName() {
            throw new UnsupportedOperationException();
        }

        public String toString() {
            return "StackMarker";
        }
    }
}

