/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.smt.scripttransfer;

import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.SmtUtils;
import de.uni_freiburg.informatik.ultimate.logic.AnnotatedTerm;
import de.uni_freiburg.informatik.ultimate.logic.Annotation;
import de.uni_freiburg.informatik.ultimate.logic.ApplicationTerm;
import de.uni_freiburg.informatik.ultimate.logic.ConstantTerm;
import de.uni_freiburg.informatik.ultimate.logic.FunctionSymbol;
import de.uni_freiburg.informatik.ultimate.logic.LetTerm;
import de.uni_freiburg.informatik.ultimate.logic.QuantifiedFormula;
import de.uni_freiburg.informatik.ultimate.logic.Rational;
import de.uni_freiburg.informatik.ultimate.logic.Script;
import de.uni_freiburg.informatik.ultimate.logic.Sort;
import de.uni_freiburg.informatik.ultimate.logic.Term;
import de.uni_freiburg.informatik.ultimate.logic.TermTransformer;
import de.uni_freiburg.informatik.ultimate.logic.TermVariable;
import java.math.BigDecimal;
import java.math.BigInteger;

public final class NonDeclaringTermTransferrer
extends TermTransformer {
    private final boolean mApplyLocalSimplifications;
    private final Script mScript;

    public NonDeclaringTermTransferrer(Script script) {
        this(script, false);
    }

    public NonDeclaringTermTransferrer(Script script, boolean applyLocalSimplifications) {
        this.mScript = script;
        this.mApplyLocalSimplifications = applyLocalSimplifications;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected void convert(Term term) {
        if (term instanceof TermVariable) {
            TermVariable result = this.transferTermVariable((TermVariable)term);
            this.setResult((Term)result);
            return;
        } else if (term instanceof ConstantTerm) {
            Term result;
            Sort sort = this.transferSort(term.getSort());
            ConstantTerm ct = (ConstantTerm)term;
            if (ct.getValue() instanceof BigInteger) {
                result = this.mScript.numeral((BigInteger)ct.getValue());
            } else if (ct.getValue() instanceof BigDecimal) {
                result = this.mScript.decimal((BigDecimal)ct.getValue());
            } else if (ct.getValue() instanceof Rational) {
                result = ((Rational)ct.getValue()).toTerm(sort);
            } else {
                if (!(ct.getValue() instanceof String)) throw new AssertionError((Object)("unexpected ConstantTerm (maybe not yet implemented)" + term));
                String value = (String)ct.getValue();
                if (value.startsWith("#x")) {
                    result = this.mScript.hexadecimal(value);
                } else {
                    if (!value.startsWith("#b")) throw new AssertionError((Object)("unexpected ConstantTerm (maybe not yet implemented)" + term));
                    result = this.mScript.binary(value);
                }
            }
            this.setResult(result);
            return;
        } else {
            super.convert(term);
        }
    }

    TermVariable transferTermVariable(TermVariable tv) {
        Sort sort = this.transferSort(tv.getSort());
        TermVariable transferResult = this.mScript.variable(tv.getName(), sort);
        return transferResult;
    }

    public Sort transferSort(Sort sort) {
        Sort[] arguments = this.transferSorts(sort.getArguments());
        String[] indices = sort.getIndices();
        return this.mScript.sort(sort.getName(), indices, arguments);
    }

    public Sort[] transferSorts(Sort[] sorts) {
        Sort[] result = new Sort[sorts.length];
        int i = 0;
        while (i < sorts.length) {
            result[i] = this.transferSort(sorts[i]);
            ++i;
        }
        return result;
    }

    public void convertApplicationTerm(ApplicationTerm appTerm, Term[] newArgs) {
        FunctionSymbol fsymb = appTerm.getFunction();
        Sort resultSort = fsymb.isReturnOverload() ? this.transferSort(fsymb.getReturnSort()) : null;
        Term result = this.mApplyLocalSimplifications ? SmtUtils.termWithLocalSimplification(this.mScript, fsymb, newArgs) : this.mScript.term(fsymb.getName(), appTerm.getFunction().getIndices(), resultSort, newArgs);
        this.setResult(result);
    }

    public void postConvertLet(LetTerm oldLet, Term[] newValues, Term newBody) {
        throw new UnsupportedOperationException("not yet implemented");
    }

    public void postConvertQuantifier(QuantifiedFormula old, Term newBody) {
        TermVariable[] vars = new TermVariable[old.getVariables().length];
        int i = 0;
        while (i < old.getVariables().length) {
            vars[i] = this.transferTermVariable(old.getVariables()[i]);
            ++i;
        }
        Term result = this.mScript.quantifier(old.getQuantifier(), vars, newBody, (Term[][])new Term[0][]);
        this.setResult(result);
    }

    public void postConvertAnnotation(AnnotatedTerm old, Annotation[] newAnnots, Term newBody) {
        Term result = this.mScript.annotate(newBody, newAnnots);
        this.setResult(result);
    }
}

