/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.smt.scripttransfer;

import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.smt.scripttransfer.HistoryRecordingScript;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.smt.scripttransfer.ISmtDeclarable;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.SmtUtils;
import de.uni_freiburg.informatik.ultimate.logic.AnnotatedTerm;
import de.uni_freiburg.informatik.ultimate.logic.Annotation;
import de.uni_freiburg.informatik.ultimate.logic.ApplicationTerm;
import de.uni_freiburg.informatik.ultimate.logic.ConstantTerm;
import de.uni_freiburg.informatik.ultimate.logic.FunctionSymbol;
import de.uni_freiburg.informatik.ultimate.logic.LetTerm;
import de.uni_freiburg.informatik.ultimate.logic.QuantifiedFormula;
import de.uni_freiburg.informatik.ultimate.logic.Rational;
import de.uni_freiburg.informatik.ultimate.logic.Script;
import de.uni_freiburg.informatik.ultimate.logic.Sort;
import de.uni_freiburg.informatik.ultimate.logic.Term;
import de.uni_freiburg.informatik.ultimate.logic.TermTransformer;
import de.uni_freiburg.informatik.ultimate.logic.TermVariable;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;

public class TermTransferrer
extends TermTransformer {
    private final boolean mApplyLocalSimplifications;
    protected final HistoryRecordingScript mOldScript;
    protected final HistoryRecordingScript mNewScript;
    protected final Map<Term, Term> mBacktransferMapping = new HashMap<Term, Term>();
    protected final Map<Term, Term> mTransferMapping;

    public TermTransferrer(Script oldScript, Script newScript) {
        this(oldScript, newScript, Collections.emptyMap(), false);
    }

    public TermTransferrer(Script oldScript, Script newScript, Map<Term, Term> transferMapping, boolean applyLocalSimplifications) {
        this.mOldScript = Objects.requireNonNull(HistoryRecordingScript.extractHistoryRecordingScript(oldScript), "no HistoryRecordingScript");
        this.mNewScript = Objects.requireNonNull(HistoryRecordingScript.extractHistoryRecordingScript(newScript), "no HistoryRecordingScript");
        this.mTransferMapping = transferMapping;
        this.mApplyLocalSimplifications = applyLocalSimplifications;
    }

    public Map<Term, Term> getTransferMapping() {
        return this.mTransferMapping;
    }

    public Map<Term, Term> getBacktranferMapping() {
        return this.mBacktransferMapping;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected void convert(Term term) {
        Term mappingResult = this.mTransferMapping.get(term);
        if (mappingResult != null) {
            this.setResult(mappingResult);
            return;
        }
        if (term instanceof TermVariable) {
            TermVariable result = this.transferTermVariable((TermVariable)term);
            this.setResult((Term)result);
            return;
        } else if (term instanceof ConstantTerm) {
            Term result;
            Sort sort = this.transferSort(term.getSort());
            ConstantTerm ct = (ConstantTerm)term;
            if (ct.getValue() instanceof BigInteger) {
                result = this.mNewScript.numeral((BigInteger)ct.getValue());
            } else if (ct.getValue() instanceof BigDecimal) {
                result = this.mNewScript.decimal((BigDecimal)ct.getValue());
            } else if (ct.getValue() instanceof Rational) {
                result = ((Rational)ct.getValue()).toTerm(sort);
            } else {
                if (!(ct.getValue() instanceof String)) throw new AssertionError((Object)("unexpected ConstantTerm (maybe not yet implemented)" + term));
                String value = (String)ct.getValue();
                if (value.startsWith("#x")) {
                    result = this.mNewScript.hexadecimal(value);
                } else {
                    if (!value.startsWith("#b")) throw new AssertionError((Object)("unexpected ConstantTerm (maybe not yet implemented)" + term));
                    result = this.mNewScript.binary(value);
                }
            }
            this.setResult(result);
            return;
        } else {
            super.convert(term);
        }
    }

    TermVariable transferTermVariable(TermVariable tv) {
        Sort sort = this.transferSort(tv.getSort());
        return this.mNewScript.variable(tv.getName(), sort);
    }

    public Sort transferSort(Sort sort) {
        Sort[] arguments = this.transferSorts(sort.getArguments());
        String[] indices = sort.getIndices();
        String sortName = sort.getName();
        if (!sort.isInternal() && !this.mNewScript.getSymbolTable().containsKey(sortName)) {
            ISmtDeclarable sortToDeclare = this.mOldScript.getSymbolTable().get(sortName);
            sortToDeclare.defineOrDeclare((Script)this.mNewScript);
        }
        return this.mNewScript.sort(sortName, indices, arguments);
    }

    public Sort[] transferSorts(Sort[] sorts) {
        Sort[] result = new Sort[sorts.length];
        int i = 0;
        while (i < sorts.length) {
            result[i] = this.transferSort(sorts[i]);
            ++i;
        }
        return result;
    }

    public void convertApplicationTerm(ApplicationTerm appTerm, Term[] newArgs) {
        FunctionSymbol fsymb = appTerm.getFunction();
        Sort resultSort = fsymb.isReturnOverload() ? this.transferSort(fsymb.getReturnSort()) : null;
        String funSymbName = fsymb.getName();
        if (!fsymb.isIntern() && !this.mNewScript.getSymbolTable().containsKey(funSymbName)) {
            ISmtDeclarable funToDeclare = this.mOldScript.getSymbolTable().get(funSymbName);
            funToDeclare.defineOrDeclare((Script)this.mNewScript);
        }
        Term result = this.mApplyLocalSimplifications ? SmtUtils.termWithLocalSimplification((Script)this.mNewScript, fsymb.getName(), appTerm.getFunction().getIndices(), resultSort, newArgs) : this.mNewScript.term(fsymb.getName(), appTerm.getFunction().getIndices(), resultSort, newArgs);
        this.setResult(result);
    }

    public void postConvertLet(LetTerm oldLet, Term[] newValues, Term newBody) {
        throw new UnsupportedOperationException("not yet implemented");
    }

    public void postConvertQuantifier(QuantifiedFormula old, Term newBody) {
        TermVariable[] vars = new TermVariable[old.getVariables().length];
        int i = 0;
        while (i < old.getVariables().length) {
            vars[i] = this.transferTermVariable(old.getVariables()[i]);
            ++i;
        }
        Term result = this.mNewScript.quantifier(old.getQuantifier(), vars, newBody, new Term[0][]);
        this.setResult(result);
    }

    public void postConvertAnnotation(AnnotatedTerm old, Annotation[] newAnnots, Term newBody) {
        Term result = this.mNewScript.annotate(newBody, newAnnots);
        this.setResult(result);
    }
}

