/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.smt.scripttransfer;

import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.smt.scripttransfer.TermTransferrer;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.SmtSortUtils;
import de.uni_freiburg.informatik.ultimate.logic.ApplicationTerm;
import de.uni_freiburg.informatik.ultimate.logic.QuantifiedFormula;
import de.uni_freiburg.informatik.ultimate.logic.Script;
import de.uni_freiburg.informatik.ultimate.logic.Sort;
import de.uni_freiburg.informatik.ultimate.logic.Term;
import de.uni_freiburg.informatik.ultimate.util.ConstructionCache;
import java.util.Arrays;

public class TermTransferrerBooleanCore
extends TermTransferrer {
    private final Term mAuxiliaryTerm = this.constructAuxiliaryTerm();
    private static final String FRESH_TERM_PREFIX = "FBV_";
    private int mFreshTermCounter = 0;
    private final ConstructionCache<Term, Term> mConstructionCache = new ConstructionCache(this::constructTerm);

    public TermTransferrerBooleanCore(Script oldScript, Script newScript) {
        super(oldScript, newScript);
    }

    private Term constructAuxiliaryTerm() {
        String name = String.valueOf(((Object)((Object)this)).getClass().getCanonicalName()) + "_AUX";
        this.mNewScript.declareFun(name, new Sort[0], SmtSortUtils.getBoolSort((Script)this.mNewScript));
        return this.mNewScript.term(name, new Term[0]);
    }

    private Term constructTerm(Term key) {
        String name = FRESH_TERM_PREFIX + this.mFreshTermCounter;
        ++this.mFreshTermCounter;
        this.mNewScript.declareFun(name, new Sort[0], SmtSortUtils.getBoolSort((Script)this.mNewScript));
        Term value = this.mNewScript.term(name, new Term[0]);
        this.mBacktransferMapping.put(value, key);
        return value;
    }

    @Override
    protected void convert(Term term) {
        if (!SmtSortUtils.isBoolSort(term.getSort())) {
            this.setResult(this.mAuxiliaryTerm);
        } else if (term instanceof QuantifiedFormula) {
            Term result = (Term)this.mConstructionCache.getOrConstruct((Object)term);
            this.setResult(result);
        } else {
            super.convert(term);
        }
    }

    @Override
    public void convertApplicationTerm(ApplicationTerm appTerm, Term[] newArgs) {
        if (Arrays.asList(newArgs).contains(this.mAuxiliaryTerm)) {
            Term result = (Term)this.mConstructionCache.getOrConstruct((Object)appTerm);
            this.setResult(result);
        } else {
            super.convertApplicationTerm(appTerm, newArgs);
        }
    }
}

