/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.lib.smtlibutils;

import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.CommuhashUtils;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.SmtSortUtils;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.SmtUtils;
import de.uni_freiburg.informatik.ultimate.logic.ApplicationTerm;
import de.uni_freiburg.informatik.ultimate.logic.ConstantTerm;
import de.uni_freiburg.informatik.ultimate.logic.FunctionSymbol;
import de.uni_freiburg.informatik.ultimate.logic.Script;
import de.uni_freiburg.informatik.ultimate.logic.Sort;
import de.uni_freiburg.informatik.ultimate.logic.Term;
import de.uni_freiburg.informatik.ultimate.util.datastructures.BitvectorConstant;
import java.math.BigInteger;
import java.util.function.Function;

public final class BitvectorUtils {
    private static final String BITVEC_CONST_PATTERN = "bv\\d+";

    private BitvectorUtils() {
    }

    public static boolean isBitvectorConstant(FunctionSymbol symb) {
        return symb.isIntern() && symb.getName().matches(BITVEC_CONST_PATTERN);
    }

    public static boolean isBitvectorConstant(BigInteger number, Term term) {
        BitvectorConstant bvConst = BitvectorUtils.constructBitvectorConstant(term);
        if (bvConst == null) {
            return false;
        }
        return bvConst.getValue().equals(number);
    }

    public static BitvectorConstant constructBitvectorConstant(Term term) {
        if (term instanceof ApplicationTerm) {
            ApplicationTerm appTerm;
            FunctionSymbol symb;
            if (SmtSortUtils.isBitvecSort(term.getSort()) && term.getSort().getIndices().length == 1 && BitvectorUtils.isBitvectorConstant(symb = (appTerm = (ApplicationTerm)term).getFunction())) {
                assert (symb.getName().startsWith("bv"));
                String valueString = symb.getName().substring(2);
                BigInteger value = new BigInteger(valueString);
                return BitvectorUtils.constructBitvectorConstant(value, term.getSort());
            }
        } else if (term instanceof ConstantTerm && SmtSortUtils.isBitvecSort(term.getSort())) {
            ConstantTerm constTerm = (ConstantTerm)term;
            if (constTerm.getValue() instanceof String) {
                BigInteger value;
                String bitString = (String)constTerm.getValue();
                if (bitString.startsWith("#b")) {
                    value = new BigInteger(bitString.substring(2), 2);
                } else if (bitString.startsWith("#x")) {
                    value = new BigInteger(bitString.substring(2), 16);
                } else {
                    throw new AssertionError((Object)"Unexpected constant value");
                }
                return BitvectorUtils.constructBitvectorConstant(value, term.getSort());
            }
            throw new UnsupportedOperationException("Unexpected value of bitvector constant");
        }
        return null;
    }

    public static BitvectorConstant constructBitvectorConstant(BigInteger value, Sort sort) {
        String index = sort.getIndices()[0];
        return new BitvectorConstant(value, index);
    }

    public static Term constructTerm(Script script, BigInteger value, Sort sort) {
        String index = sort.getIndices()[0];
        return BitvectorUtils.constructTerm(script, new BitvectorConstant(value, index));
    }

    public static Term constructTerm(Script script, BitvectorConstant bitvec) {
        String funcname = "bv" + bitvec.getValue().toString();
        return script.term(funcname, new String[]{bitvec.getStringIndex()}, null, new Term[0]);
    }

    public static boolean allTermsAreBitvectorConstants(Term[] terms) {
        Term[] termArray = terms;
        int n = terms.length;
        int n2 = 0;
        while (n2 < n) {
            Term term = termArray[n2];
            if (!SmtSortUtils.isBitvecSort(term.getSort())) {
                return false;
            }
            if (term instanceof ApplicationTerm) {
                ApplicationTerm appTerm = (ApplicationTerm)term;
                if (!BitvectorUtils.isBitvectorConstant(appTerm.getFunction())) {
                    return false;
                }
            } else {
                return false;
            }
            ++n2;
        }
        return true;
    }

    public static Term termWithLocalSimplification(Script script, String funcname, BigInteger[] indices, Term ... params) {
        Term result;
        BitvectorConstant.BvOp bvop = BitvectorConstant.BvOp.valueOf((String)funcname);
        switch (bvop) {
            case zero_extend: {
                result = new Zero_extend().simplifiedResult(script, funcname, indices, params);
                break;
            }
            case sign_extend: {
                result = new Sign_extend().simplifiedResult(script, funcname, indices, params);
                break;
            }
            case extract: {
                result = new Extract().simplifiedResult(script, funcname, indices, params);
                break;
            }
            case concat: {
                result = new Concat().simplifiedResult(script, funcname, indices, params);
                break;
            }
            case bvadd: {
                result = new RegularBitvectorOperation_BitvectorResult(funcname, x -> y -> BitvectorConstant.bvadd((BitvectorConstant)x, (BitvectorConstant)y)).simplifiedResult(script, funcname, indices, params);
                break;
            }
            case bvsub: {
                result = new RegularBitvectorOperation_BitvectorResult(funcname, x -> y -> BitvectorConstant.bvsub((BitvectorConstant)x, (BitvectorConstant)y)).simplifiedResult(script, funcname, indices, params);
                break;
            }
            case bvudiv: {
                result = new RegularBitvectorOperation_BitvectorResult(funcname, x -> y -> BitvectorConstant.bvudiv((BitvectorConstant)x, (BitvectorConstant)y)).simplifiedResult(script, funcname, indices, params);
                break;
            }
            case bvurem: {
                result = new RegularBitvectorOperation_BitvectorResult(funcname, x -> y -> BitvectorConstant.bvurem((BitvectorConstant)x, (BitvectorConstant)y)).simplifiedResult(script, funcname, indices, params);
                break;
            }
            case bvsdiv: {
                result = new RegularBitvectorOperation_BitvectorResult(funcname, x -> y -> BitvectorConstant.bvsdiv((BitvectorConstant)x, (BitvectorConstant)y)).simplifiedResult(script, funcname, indices, params);
                break;
            }
            case bvsrem: {
                result = new RegularBitvectorOperation_BitvectorResult(funcname, x -> y -> BitvectorConstant.bvsrem((BitvectorConstant)x, (BitvectorConstant)y)).simplifiedResult(script, funcname, indices, params);
                break;
            }
            case bvsmod: {
                result = new RegularBitvectorOperation_BitvectorResult(funcname, x -> y -> BitvectorConstant.bvsmod((BitvectorConstant)x, (BitvectorConstant)y)).simplifiedResult(script, funcname, indices, params);
                break;
            }
            case bvmul: {
                result = new RegularBitvectorOperation_BitvectorResult(funcname, x -> y -> BitvectorConstant.bvmul((BitvectorConstant)x, (BitvectorConstant)y)).simplifiedResult(script, funcname, indices, params);
                break;
            }
            case bvand: {
                result = new Bvand().simplifiedResult(script, funcname, indices, params);
                break;
            }
            case bvor: {
                result = new RegularBitvectorOperation_BitvectorResult(funcname, x -> y -> BitvectorConstant.bvor((BitvectorConstant)x, (BitvectorConstant)y)).simplifiedResult(script, funcname, indices, params);
                break;
            }
            case bvxor: {
                result = new RegularBitvectorOperation_BitvectorResult(funcname, x -> y -> BitvectorConstant.bvxor((BitvectorConstant)x, (BitvectorConstant)y)).simplifiedResult(script, funcname, indices, params);
                break;
            }
            case bvnot: {
                result = new Bvnot().simplifiedResult(script, funcname, indices, params);
                break;
            }
            case bvneg: {
                result = new Bvneg().simplifiedResult(script, funcname, indices, params);
                break;
            }
            case bvshl: {
                result = new RegularBitvectorOperation_BitvectorResult(funcname, x -> y -> BitvectorConstant.bvshl((BitvectorConstant)x, (BitvectorConstant)y)).simplifiedResult(script, funcname, indices, params);
                break;
            }
            case bvlshr: {
                result = new RegularBitvectorOperation_BitvectorResult(funcname, x -> y -> BitvectorConstant.bvlshr((BitvectorConstant)x, (BitvectorConstant)y)).simplifiedResult(script, funcname, indices, params);
                break;
            }
            case bvashr: {
                result = new RegularBitvectorOperation_BitvectorResult(funcname, x -> y -> BitvectorConstant.bvashr((BitvectorConstant)x, (BitvectorConstant)y)).simplifiedResult(script, funcname, indices, params);
                break;
            }
            case bvult: {
                result = new RegularBitvectorOperation_BooleanResult(funcname, x -> y -> BitvectorConstant.bvult((BitvectorConstant)x, (BitvectorConstant)y)).simplifiedResult(script, funcname, indices, params);
                break;
            }
            case bvule: {
                result = new RegularBitvectorOperation_BooleanResult(funcname, x -> y -> BitvectorConstant.bvule((BitvectorConstant)x, (BitvectorConstant)y)).simplifiedResult(script, funcname, indices, params);
                break;
            }
            case bvugt: {
                result = new RegularBitvectorOperation_BooleanResult(funcname, x -> y -> BitvectorConstant.bvugt((BitvectorConstant)x, (BitvectorConstant)y)).simplifiedResult(script, funcname, indices, params);
                break;
            }
            case bvuge: {
                result = new RegularBitvectorOperation_BooleanResult(funcname, x -> y -> BitvectorConstant.bvuge((BitvectorConstant)x, (BitvectorConstant)y)).simplifiedResult(script, funcname, indices, params);
                break;
            }
            case bvslt: {
                result = new RegularBitvectorOperation_BooleanResult(funcname, x -> y -> BitvectorConstant.bvslt((BitvectorConstant)x, (BitvectorConstant)y)).simplifiedResult(script, funcname, indices, params);
                break;
            }
            case bvsle: {
                result = new RegularBitvectorOperation_BooleanResult(funcname, x -> y -> BitvectorConstant.bvsle((BitvectorConstant)x, (BitvectorConstant)y)).simplifiedResult(script, funcname, indices, params);
                break;
            }
            case bvsgt: {
                result = new RegularBitvectorOperation_BooleanResult(funcname, x -> y -> BitvectorConstant.bvsgt((BitvectorConstant)x, (BitvectorConstant)y)).simplifiedResult(script, funcname, indices, params);
                break;
            }
            case bvsge: {
                result = new RegularBitvectorOperation_BooleanResult(funcname, x -> y -> BitvectorConstant.bvsge((BitvectorConstant)x, (BitvectorConstant)y)).simplifiedResult(script, funcname, indices, params);
                break;
            }
            default: {
                if (BitvectorUtils.allTermsAreBitvectorConstants(params)) {
                    throw new AssertionError((Object)("wasted optimization " + funcname));
                }
                result = SmtUtils.oldAPITerm(script, funcname, indices, null, params);
            }
        }
        return result;
    }

    private static abstract class BitvectorOperation {
        private BitvectorOperation() {
        }

        public final Term simplifiedResult(Script script, String funcname, BigInteger[] indices, Term ... params) {
            assert (this.getFunctionName().equals(funcname)) : "wrong function name";
            assert (this.getNumberOfIndices() == 0 && indices == null || this.getNumberOfIndices() == indices.length) : "wrong number of indices";
            assert (this.getNumberOfParams() == params.length) : "wrong number of params";
            BitvectorConstant[] bvs = new BitvectorConstant[params.length];
            boolean allConstant = true;
            int i = 0;
            while (i < params.length) {
                bvs[i] = BitvectorUtils.constructBitvectorConstant(params[i]);
                allConstant &= bvs[i] != null;
                ++i;
            }
            if (allConstant) {
                return this.simplify_ConstantCase(script, indices, bvs);
            }
            return this.simplify_NonConstantCase(script, indices, params, bvs);
        }

        protected Term simplify_NonConstantCase(Script script, BigInteger[] indices, Term[] params, BitvectorConstant[] bvs) {
            return this.notSimplified(script, indices, params);
        }

        private final Term notSimplified(Script script, BigInteger[] indices, Term[] params) {
            Term[] newParams = this.isCommutative() ? CommuhashUtils.sortByHashCode(params) : params;
            return SmtUtils.oldAPITerm(script, this.getFunctionName(), indices, null, newParams);
        }

        public abstract String getFunctionName();

        public abstract boolean isCommutative();

        public abstract int getNumberOfIndices();

        public abstract int getNumberOfParams();

        public abstract Term simplify_ConstantCase(Script var1, BigInteger[] var2, BitvectorConstant[] var3);
    }

    private static class Bvand
    extends RegularBitvectorOperation_BitvectorResult {
        public Bvand() {
            super("bvand", x -> y -> BitvectorConstant.bvand((BitvectorConstant)x, (BitvectorConstant)y));
        }

        @Override
        protected Term simplify_NonConstantCase(Script script, BigInteger[] indices, Term[] params, BitvectorConstant[] bvs) {
            BitvectorConstant[] bitvectorConstantArray = bvs;
            int n = bvs.length;
            int n2 = 0;
            while (n2 < n) {
                BitvectorConstant bvConst = bitvectorConstantArray[n2];
                if (bvConst != null && bvConst.getValue().equals(BigInteger.ZERO)) {
                    return BitvectorUtils.constructTerm(script, bvConst);
                }
                ++n2;
            }
            return super.simplify_NonConstantCase(script, indices, params, bvs);
        }
    }

    private static class Bvneg
    extends BitvectorOperation {
        private Bvneg() {
        }

        @Override
        public String getFunctionName() {
            return "bvneg";
        }

        @Override
        public boolean isCommutative() {
            return false;
        }

        @Override
        public int getNumberOfIndices() {
            return 0;
        }

        @Override
        public int getNumberOfParams() {
            return 1;
        }

        @Override
        public Term simplify_ConstantCase(Script script, BigInteger[] indices, BitvectorConstant[] bvs) {
            return BitvectorUtils.constructTerm(script, BitvectorConstant.bvneg((BitvectorConstant)bvs[0]));
        }
    }

    private static class Bvnot
    extends BitvectorOperation {
        private Bvnot() {
        }

        @Override
        public String getFunctionName() {
            return "bvnot";
        }

        @Override
        public boolean isCommutative() {
            return false;
        }

        @Override
        public int getNumberOfIndices() {
            return 0;
        }

        @Override
        public int getNumberOfParams() {
            return 1;
        }

        @Override
        public Term simplify_ConstantCase(Script script, BigInteger[] indices, BitvectorConstant[] bvs) {
            return BitvectorUtils.constructTerm(script, BitvectorConstant.bvnot((BitvectorConstant)bvs[0]));
        }
    }

    private static class Concat
    extends BitvectorOperation {
        private Concat() {
        }

        @Override
        public String getFunctionName() {
            return "concat";
        }

        @Override
        public boolean isCommutative() {
            return false;
        }

        @Override
        public int getNumberOfIndices() {
            return 0;
        }

        @Override
        public int getNumberOfParams() {
            return 2;
        }

        @Override
        public Term simplify_ConstantCase(Script script, BigInteger[] indices, BitvectorConstant[] bvs) {
            BitvectorConstant bv = BitvectorConstant.concat((BitvectorConstant)bvs[0], (BitvectorConstant)bvs[1]);
            return BitvectorUtils.constructTerm(script, bv);
        }
    }

    private static class Extract
    extends BitvectorOperation {
        private Extract() {
        }

        @Override
        public String getFunctionName() {
            return "extract";
        }

        @Override
        public boolean isCommutative() {
            return false;
        }

        @Override
        public int getNumberOfIndices() {
            return 2;
        }

        @Override
        public int getNumberOfParams() {
            return 1;
        }

        @Override
        public Term simplify_ConstantCase(Script script, BigInteger[] indices, BitvectorConstant[] bvs) {
            BitvectorConstant bv = BitvectorConstant.extract((BitvectorConstant)bvs[0], (int)indices[0].intValueExact(), (int)indices[1].intValueExact());
            return BitvectorUtils.constructTerm(script, bv);
        }
    }

    private static abstract class RegularBitvectorOperation
    extends BitvectorOperation {
        private RegularBitvectorOperation() {
        }

        @Override
        public int getNumberOfIndices() {
            return 0;
        }

        @Override
        public int getNumberOfParams() {
            return 2;
        }
    }

    private static class RegularBitvectorOperation_BitvectorResult
    extends RegularBitvectorOperation {
        private final String mName;
        private final Function<BitvectorConstant, Function<BitvectorConstant, BitvectorConstant>> mConstantSimplification;

        public RegularBitvectorOperation_BitvectorResult(String name, Function<BitvectorConstant, Function<BitvectorConstant, BitvectorConstant>> function) {
            this.mName = name;
            this.mConstantSimplification = function;
        }

        @Override
        public String getFunctionName() {
            return this.mName;
        }

        @Override
        public boolean isCommutative() {
            BitvectorConstant.BvOp bvop = BitvectorConstant.BvOp.valueOf((String)this.getFunctionName());
            switch (bvop) {
                case bvadd: 
                case bvmul: 
                case bvand: 
                case bvor: 
                case bvxor: {
                    return true;
                }
                case bvsub: 
                case bvudiv: 
                case bvurem: 
                case bvsdiv: 
                case bvsrem: 
                case bvsmod: 
                case bvshl: 
                case bvlshr: 
                case bvashr: {
                    return false;
                }
                case sign_extend: 
                case zero_extend: 
                case extract: 
                case concat: 
                case bvnot: 
                case bvneg: 
                case bvult: 
                case bvule: 
                case bvugt: 
                case bvuge: 
                case bvslt: 
                case bvsle: 
                case bvsgt: 
                case bvsge: {
                    throw new AssertionError((Object)("Not a regular bitvector operator with bitvector result: " + bvop));
                }
            }
            throw new UnsupportedOperationException("Unknown bitvector operator: " + bvop);
        }

        @Override
        public Term simplify_ConstantCase(Script script, BigInteger[] indices, BitvectorConstant[] bvs) {
            if (bvs.length != this.getNumberOfParams()) {
                throw new AssertionError((Object)"supported and provided parameters differ - feature not yet implemented");
            }
            return BitvectorUtils.constructTerm(script, this.mConstantSimplification.apply(bvs[0]).apply(bvs[1]));
        }
    }

    private static class RegularBitvectorOperation_BooleanResult
    extends RegularBitvectorOperation {
        private final String mName;
        private final Function<BitvectorConstant, Function<BitvectorConstant, Boolean>> mFunction;

        public RegularBitvectorOperation_BooleanResult(String name, Function<BitvectorConstant, Function<BitvectorConstant, Boolean>> function) {
            this.mName = name;
            this.mFunction = function;
        }

        @Override
        public String getFunctionName() {
            return this.mName;
        }

        @Override
        public boolean isCommutative() {
            return false;
        }

        @Override
        public Term simplify_ConstantCase(Script script, BigInteger[] indices, BitvectorConstant[] bvs) {
            return script.term(String.valueOf(this.mFunction.apply(bvs[0]).apply(bvs[1])), new Term[0]);
        }
    }

    private static class Sign_extend
    extends BitvectorOperation {
        private Sign_extend() {
        }

        @Override
        public String getFunctionName() {
            return "sign_extend";
        }

        @Override
        public boolean isCommutative() {
            return false;
        }

        @Override
        public int getNumberOfIndices() {
            return 1;
        }

        @Override
        public int getNumberOfParams() {
            return 1;
        }

        @Override
        public Term simplify_ConstantCase(Script script, BigInteger[] indices, BitvectorConstant[] bvs) {
            BitvectorConstant bv = BitvectorConstant.sign_extend((BitvectorConstant)bvs[0], (BigInteger)indices[0]);
            return BitvectorUtils.constructTerm(script, bv);
        }
    }

    private static class Zero_extend
    extends BitvectorOperation {
        private Zero_extend() {
        }

        @Override
        public String getFunctionName() {
            return "zero_extend";
        }

        @Override
        public boolean isCommutative() {
            return false;
        }

        @Override
        public int getNumberOfIndices() {
            return 1;
        }

        @Override
        public int getNumberOfParams() {
            return 1;
        }

        @Override
        public Term simplify_ConstantCase(Script script, BigInteger[] indices, BitvectorConstant[] bvs) {
            BitvectorConstant bv = BitvectorConstant.zero_extend((BitvectorConstant)bvs[0], (BigInteger)indices[0]);
            return BitvectorUtils.constructTerm(script, bv);
        }
    }
}

