/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.lib.smtlibutils;

import de.uni_freiburg.informatik.ultimate.core.model.services.ILogger;
import de.uni_freiburg.informatik.ultimate.core.model.services.IUltimateServiceProvider;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.CommuhashUtils;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.SmtUtils;
import de.uni_freiburg.informatik.ultimate.logic.ApplicationTerm;
import de.uni_freiburg.informatik.ultimate.logic.QuantifiedFormula;
import de.uni_freiburg.informatik.ultimate.logic.Script;
import de.uni_freiburg.informatik.ultimate.logic.Sort;
import de.uni_freiburg.informatik.ultimate.logic.Term;
import de.uni_freiburg.informatik.ultimate.logic.TermTransformer;
import de.uni_freiburg.informatik.ultimate.logic.TermVariable;
import java.math.BigInteger;
import java.util.Arrays;
import java.util.HashSet;

public class CommuhashNormalForm {
    private static final boolean DEBUG_LOG_SIZES = false;
    private static final boolean DEBUG_CHECK_CORRECTNESS = false;
    private final IUltimateServiceProvider mServices;
    private final Script mScript;

    public CommuhashNormalForm(IUltimateServiceProvider services, Script script) {
        this.mServices = services;
        this.mScript = script;
    }

    public Term transform(Term term) {
        ILogger logger = this.mServices.getLoggingService().getLogger(CommuhashNormalForm.class.getSimpleName());
        Term result = new CommuhashNormalFormHelper().transform(term);
        return result;
    }

    private class CommuhashNormalFormHelper
    extends TermTransformer {
        private CommuhashNormalFormHelper() {
        }

        public void convertApplicationTerm(ApplicationTerm appTerm, Term[] newArgs) {
            String funcname = appTerm.getFunction().getName();
            if (CommuhashUtils.isKnownToBeCommutative(funcname)) {
                Sort resultSort = appTerm.getFunction().isReturnOverload() ? appTerm.getFunction().getReturnSort() : null;
                Term simplified = this.constructlocallySimplifiedTermWithSortedParams(funcname, null, resultSort, newArgs);
                this.setResult(simplified);
            } else {
                super.convertApplicationTerm(appTerm, newArgs);
            }
        }

        private Term constructlocallySimplifiedTermWithSortedParams(String funcname, BigInteger[] indices, Sort resultSort, Term[] params) {
            Term[] sortedParams = CommuhashUtils.sortByHashCode(params);
            Term simplified = SmtUtils.termWithLocalSimplification(CommuhashNormalForm.this.mScript, funcname, SmtUtils.toStringArray(indices), resultSort, sortedParams);
            return simplified;
        }

        public void postConvertQuantifier(QuantifiedFormula old, Term newBody) {
            Term result = SmtUtils.quantifier(CommuhashNormalForm.this.mScript, old.getQuantifier(), new HashSet<TermVariable>(Arrays.asList(old.getVariables())), newBody);
            this.setResult(result);
        }
    }
}

