/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.lib.smtlibutils;

import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.SubtermPropertyChecker;
import de.uni_freiburg.informatik.ultimate.logic.ApplicationTerm;
import de.uni_freiburg.informatik.ultimate.logic.Script;
import de.uni_freiburg.informatik.ultimate.logic.Sort;
import de.uni_freiburg.informatik.ultimate.logic.Term;
import java.util.Arrays;
import java.util.Comparator;
import java.util.function.Predicate;

public class CommuhashUtils {
    public static final String[] COMMUTATIVE_OPERATORS = new String[]{"and", "or", "=", "distinct", "+", "*", "bvadd", "bvmul", "bvand", "bvor", "bvxor"};
    public static final Comparator<Term> HASH_BASED_COMPERATOR = new Comparator<Term>(){

        @Override
        public int compare(Term arg0, Term arg1) {
            if (arg0 == arg1) {
                return 0;
            }
            if (arg0.hashCode() == arg1.hashCode()) {
                return arg0.toString().compareTo(arg1.toString());
            }
            return Integer.compare(arg0.hashCode(), arg1.hashCode());
        }
    };

    private CommuhashUtils() {
    }

    public static boolean isKnownToBeCommutative(String name) {
        switch (name) {
            case "*": 
            case "+": 
            case "=": 
            case "or": 
            case "and": 
            case "bvor": 
            case "bvadd": 
            case "bvand": 
            case "bvmul": 
            case "bvxor": 
            case "distinct": {
                return true;
            }
        }
        return false;
    }

    public static Term[] sortByHashCode(Term ... params) {
        Term[] sortedParams = (Term[])params.clone();
        Arrays.sort(sortedParams, HASH_BASED_COMPERATOR);
        return sortedParams;
    }

    public static Term term(Script script, String funcname, String[] indices, Sort returnSort, Term ... params) {
        if (CommuhashUtils.isKnownToBeCommutative(funcname)) {
            return script.term(funcname, indices, returnSort, CommuhashUtils.sortByHashCode(params));
        }
        return script.term(funcname, indices, returnSort, params);
    }

    public static boolean isInCommuhashNormalForm(Term term, String ... operators) {
        Predicate<Term> property = x -> !CommuhashUtils.rootInCommuhashNormalForm(x, operators);
        return !new SubtermPropertyChecker(property).isSatisfiedBySomeSubterm(term);
    }

    private static boolean rootInCommuhashNormalForm(Term term, String ... operators) {
        boolean result;
        if (term instanceof ApplicationTerm) {
            ApplicationTerm appTerm = (ApplicationTerm)term;
            result = Arrays.asList(operators).contains(appTerm.getFunction().getName()) ? CommuhashUtils.areParamsSorted(appTerm.getParameters()) : true;
        } else {
            result = true;
        }
        return result;
    }

    private static boolean areParamsSorted(Term[] params) {
        Object[] sorted = CommuhashUtils.sortByHashCode(params);
        return Arrays.equals(params, sorted);
    }
}

