/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.lib.smtlibutils;

import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.ManagedScript;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.SmtUtils;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.Substitution;
import de.uni_freiburg.informatik.ultimate.logic.Script;
import de.uni_freiburg.informatik.ultimate.logic.Term;
import de.uni_freiburg.informatik.ultimate.logic.TermVariable;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Map;

public class IncrementalPlicationChecker {
    private final ManagedScript mMgdScript;
    private final Term mLhs;
    private boolean mLhsIsAsserted;
    private Map<TermVariable, Term> mVar2ConstSubstitution;
    private final Plication mPlication;

    public static Validity convertLBool2Validity(Script.LBool lbool) {
        switch (lbool) {
            case SAT: {
                return Validity.INVALID;
            }
            case UNKNOWN: {
                return Validity.UNKNOWN;
            }
            case UNSAT: {
                return Validity.VALID;
            }
        }
        throw new AssertionError();
    }

    public static Script.LBool convertValidity2Lbool(Validity validity) {
        switch (validity) {
            case INVALID: {
                return Script.LBool.SAT;
            }
            case NOT_CHECKED: {
                throw new AssertionError();
            }
            case UNKNOWN: {
                return Script.LBool.UNKNOWN;
            }
            case VALID: {
                return Script.LBool.UNSAT;
            }
        }
        throw new AssertionError();
    }

    public IncrementalPlicationChecker(Plication plication, ManagedScript mgdScript, Term lhs) {
        this.mPlication = plication;
        this.mMgdScript = mgdScript;
        this.mLhs = lhs;
        this.mLhsIsAsserted = false;
    }

    private void assertLhs(Term lhs) {
        Term assertTerm;
        assert (!this.mLhsIsAsserted) : "must not assert lhs twice";
        this.mMgdScript.lock(this);
        this.mMgdScript.push(this, 1);
        this.mVar2ConstSubstitution = this.constructVar2ConstSubstitution(lhs);
        switch (this.mPlication) {
            case EXPLICATION: {
                assertTerm = SmtUtils.not(this.mMgdScript.getScript(), lhs);
                break;
            }
            case IMPLICATION: {
                assertTerm = lhs;
                break;
            }
            default: {
                throw new AssertionError((Object)"unknown case");
            }
        }
        this.mMgdScript.assertTerm(this, Substitution.apply(this.mMgdScript, this.mVar2ConstSubstitution, assertTerm));
        this.mLhsIsAsserted = true;
    }

    private Map<TermVariable, Term> constructVar2ConstSubstitution(Term term) {
        HashSet<TermVariable> allTvs = new HashSet<TermVariable>(Arrays.asList(term.getFreeVars()));
        Map<TermVariable, Term> substitutionMapping = SmtUtils.termVariables2Constants(this.mMgdScript.getScript(), allTvs, true);
        return substitutionMapping;
    }

    public Validity checkPlication(Term rhs) {
        Term assertTerm;
        if (!this.mLhsIsAsserted) {
            this.assertLhs(this.mLhs);
        }
        this.mMgdScript.push(this, 1);
        switch (this.mPlication) {
            case EXPLICATION: {
                assertTerm = rhs;
                break;
            }
            case IMPLICATION: {
                assertTerm = SmtUtils.not(this.mMgdScript.getScript(), rhs);
                break;
            }
            default: {
                throw new AssertionError((Object)"unknown case");
            }
        }
        this.mMgdScript.assertTerm(this, Substitution.apply(this.mMgdScript, this.mVar2ConstSubstitution, assertTerm));
        Script.LBool isSat = this.mMgdScript.checkSat(this);
        this.mMgdScript.pop(this, 1);
        return IncrementalPlicationChecker.convertLBool2Validity(isSat);
    }

    public Script.LBool checkSat(Term additionalTerm) {
        Term assertTerm;
        if (!this.mLhsIsAsserted) {
            this.assertLhs(this.mLhs);
        }
        this.mMgdScript.push(this, 1);
        switch (this.mPlication) {
            case EXPLICATION: {
                assertTerm = additionalTerm;
                break;
            }
            case IMPLICATION: {
                assertTerm = additionalTerm;
                break;
            }
            default: {
                throw new AssertionError((Object)"unknown case");
            }
        }
        this.mMgdScript.assertTerm(this, Substitution.apply(this.mMgdScript, this.mVar2ConstSubstitution, assertTerm));
        Script.LBool isSat = this.mMgdScript.checkSat(this);
        this.mMgdScript.pop(this, 1);
        return isSat;
    }

    public void unlockSolver() {
        if (this.mLhsIsAsserted) {
            this.mMgdScript.pop(this, 1);
            this.mMgdScript.unlock(this);
        }
    }

    public static enum Plication {
        IMPLICATION,
        EXPLICATION;

    }

    public static enum Validity {
        VALID,
        INVALID,
        UNKNOWN,
        NOT_CHECKED;

    }
}

